﻿/********************************* 
 * Cognitive Networks Study Test *
 *********************************/

import { PsychoJS } from './lib_bugfix/core-2020.1.js';
import * as core from './lib_bugfix/core-2020.1.js';
import { TrialHandler } from './lib_bugfix/data-2020.1.js';
import { Scheduler } from './lib_bugfix/util-2020.1.js';
import * as util from './lib_bugfix/util-2020.1.js';
import * as visual from './lib_bugfix/visual-2020.1.js';
import * as sound from './lib_bugfix/sound-2020.1.js';

// init psychoJS:
const psychoJS = new PsychoJS({
  debug: true
});

// open window:
psychoJS.openWindow({
  fullscr: true,
  color: new util.Color([0, 0, 0]),
  units: 'height',
  waitBlanking: true
});

// store info about the experiment session:
let expName = 'Cognitive Networks Study';  // from the Builder filename that created this script
let expInfo = {'participant': '', 'session': '001'};

// schedule the experiment:
psychoJS.schedule(psychoJS.gui.DlgFromDict({
  dictionary: expInfo,
  title: expName
}));

const flowScheduler = new Scheduler(psychoJS);
const dialogCancelScheduler = new Scheduler(psychoJS);
psychoJS.scheduleCondition(function() { return (psychoJS.gui.dialogComponent.button === 'OK'); }, flowScheduler, dialogCancelScheduler);

// flowScheduler gets run if the participants presses OK
flowScheduler.add(updateInfo); // add timeStamp
flowScheduler.add(experimentInit);
flowScheduler.add(welcomeRoutineBegin());
flowScheduler.add(welcomeRoutineEachFrame());
flowScheduler.add(welcomeRoutineEnd());
/*
flowScheduler.add(SJTintruxRoutineBegin());
flowScheduler.add(SJTintruxRoutineEachFrame());
flowScheduler.add(SJTintruxRoutineEnd());
const trials_01LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_01LoopBegin, trials_01LoopScheduler);
flowScheduler.add(trials_01LoopScheduler);
flowScheduler.add(trials_01LoopEnd);
flowScheduler.add(break1RoutineBegin());
flowScheduler.add(break1RoutineEachFrame());
flowScheduler.add(break1RoutineEnd());
const trials_9LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_9LoopBegin, trials_9LoopScheduler);
flowScheduler.add(trials_9LoopScheduler);
flowScheduler.add(trials_9LoopEnd);
flowScheduler.add(stop2RoutineBegin());
flowScheduler.add(stop2RoutineEachFrame());
flowScheduler.add(stop2RoutineEnd());
const trials_10LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_10LoopBegin, trials_10LoopScheduler);
flowScheduler.add(trials_10LoopScheduler);
flowScheduler.add(trials_10LoopEnd);
flowScheduler.add(stop3RoutineBegin());
flowScheduler.add(stop3RoutineEachFrame());
flowScheduler.add(stop3RoutineEnd());
const trials_11LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_11LoopBegin, trials_11LoopScheduler);
flowScheduler.add(trials_11LoopScheduler);
flowScheduler.add(trials_11LoopEnd);
flowScheduler.add(breakNewRoutineBegin());
flowScheduler.add(breakNewRoutineEachFrame());
flowScheduler.add(breakNewRoutineEnd());
flowScheduler.add(VfluInstruxRoutineBegin());
flowScheduler.add(VfluInstruxRoutineEachFrame());
flowScheduler.add(VfluInstruxRoutineEnd());
const trials_3LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_3LoopBegin, trials_3LoopScheduler);
flowScheduler.add(trials_3LoopScheduler);
flowScheduler.add(trials_3LoopEnd);
flowScheduler.add(vocabExtendIntruxRoutineBegin());
flowScheduler.add(vocabExtendIntruxRoutineEachFrame());
flowScheduler.add(vocabExtendIntruxRoutineEnd());
const trials_4LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_4LoopBegin, trials_4LoopScheduler);
flowScheduler.add(trials_4LoopScheduler);
flowScheduler.add(trials_4LoopEnd);
const extendTrialsLoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(extendTrialsLoopBegin, extendTrialsLoopScheduler);
flowScheduler.add(extendTrialsLoopScheduler);
flowScheduler.add(extendTrialsLoopEnd);
flowScheduler.add(break99RoutineBegin());
flowScheduler.add(break99RoutineEachFrame());
flowScheduler.add(break99RoutineEnd());

*/

flowScheduler.add(FFinstruxRoutineBegin());
flowScheduler.add(FFinstruxRoutineEachFrame());
flowScheduler.add(FFinstruxRoutineEnd());
const trials_29LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_29LoopBegin, trials_29LoopScheduler);
flowScheduler.add(trials_29LoopScheduler);
flowScheduler.add(trials_29LoopEnd);

/*
flowScheduler.add(newWordRoutineBegin());
flowScheduler.add(newWordRoutineEachFrame());
flowScheduler.add(newWordRoutineEnd());
const trials_30LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_30LoopBegin, trials_30LoopScheduler);
flowScheduler.add(trials_30LoopScheduler);
flowScheduler.add(trials_30LoopEnd);
flowScheduler.add(newWord2RoutineBegin());
flowScheduler.add(newWord2RoutineEachFrame());
flowScheduler.add(newWord2RoutineEnd());
const trials_31LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_31LoopBegin, trials_31LoopScheduler);
flowScheduler.add(trials_31LoopScheduler);
flowScheduler.add(trials_31LoopEnd);
flowScheduler.add(break4RoutineBegin());
flowScheduler.add(break4RoutineEachFrame());
flowScheduler.add(break4RoutineEnd());
*/

flowScheduler.add(autInstruxRoutineBegin());
flowScheduler.add(autInstruxRoutineEachFrame());
flowScheduler.add(autInstruxRoutineEnd());
const boxTrialsLoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(boxTrialsLoopBegin, boxTrialsLoopScheduler);
flowScheduler.add(boxTrialsLoopScheduler);
flowScheduler.add(boxTrialsLoopEnd);
flowScheduler.add(nextAUTRoutineBegin());
flowScheduler.add(nextAUTRoutineEachFrame());
flowScheduler.add(nextAUTRoutineEnd());

/*
const ropeTrialsLoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(ropeTrialsLoopBegin, ropeTrialsLoopScheduler);
flowScheduler.add(ropeTrialsLoopScheduler);
flowScheduler.add(ropeTrialsLoopEnd);
flowScheduler.add(catellInstruxRoutineBegin());
flowScheduler.add(catellInstruxRoutineEachFrame());
flowScheduler.add(catellInstruxRoutineEnd());
flowScheduler.add(GetReadyRoutineBegin());
flowScheduler.add(GetReadyRoutineEachFrame());
flowScheduler.add(GetReadyRoutineEnd());
const trials_7LoopScheduler = new Scheduler(psychoJS);
flowScheduler.add(trials_7LoopBegin, trials_7LoopScheduler);
flowScheduler.add(trials_7LoopScheduler);
flowScheduler.add(trials_7LoopEnd);
flowScheduler.add(demoInstruxRoutineBegin());
flowScheduler.add(demoInstruxRoutineEachFrame());
flowScheduler.add(demoInstruxRoutineEnd());
flowScheduler.add(GenderRoutineBegin());
flowScheduler.add(GenderRoutineEachFrame());
flowScheduler.add(GenderRoutineEnd());
flowScheduler.add(AgeRoutineBegin());
flowScheduler.add(AgeRoutineEachFrame());
flowScheduler.add(AgeRoutineEnd());
flowScheduler.add(EFLRoutineBegin());
flowScheduler.add(EFLRoutineEachFrame());
flowScheduler.add(EFLRoutineEnd());
*/

flowScheduler.add(thanksRoutineBegin());
flowScheduler.add(thanksRoutineEachFrame());
flowScheduler.add(thanksRoutineEnd());
flowScheduler.add(quitPsychoJS, '', true);

// quit if user presses Cancel in dialog box:
dialogCancelScheduler.add(quitPsychoJS, '', false);

psychoJS.start({
  expName: expName,
  expInfo: expInfo,
  });


var frameDur;
function updateInfo() {
  expInfo['date'] = util.MonotonicClock.getDateStr();  // add a simple timestamp
  expInfo['expName'] = expName;
  expInfo['psychopyVersion'] = '2020.1.3';
  expInfo['OS'] = window.navigator.platform;

  // store frame rate of monitor if we can measure it successfully
  expInfo['frameRate'] = psychoJS.window.getActualFrameRate();
  if (typeof expInfo['frameRate'] !== 'undefined')
    frameDur = 1.0 / Math.round(expInfo['frameRate']);
  else
    frameDur = 1.0 / 60.0; // couldn't get a reliable measure so guess

  // add info from the URL:
  util.addInfoFromUrl(expInfo);
  
  return Scheduler.Event.NEXT;
}


var welcomeClock;
var Welcome;
var key_resp;
var text_49;
var SJTintruxClock;
var Intruxtext;
var key_resp_2;
var SJT1Clock;
var slider;
var pairs;
var Unrelated;
var Related;
var key_resp_12;
var text_19;
var SJTcounter;
var currVal1;
var text_30;
var break1Clock;
var text33;
var key_resp_18;
var SJT2Clock;
var pairs1;
var slider_2;
var related1;
var unrelated1;
var key_resp_13;
var text_20;
var SJTcounter2;
var currVal2;
var text_31;
var stop2Clock;
var text_14;
var key_resp_19;
var SJT3Clock;
var text_15;
var slider_3;
var related2;
var unrelated2;
var key_resp_14;
var text_21;
var SJTcounter3;
var currVal3;
var text_33;
var stop3Clock;
var text_16;
var key_resp_20;
var SJT4Clock;
var text_17;
var slider_4;
var related3;
var unrelated3;
var key_resp_15;
var text_22;
var SJTcounter4;
var currVal4;
var text_32;
var breakNewClock;
var text_18;
var key_resp_3;
var VfluInstruxClock;
var Instrux2;
var key_resp_4;
var vfClock;
var category;
var text;
var countdownStarted;
var minutes;
var seconds;
var timeText;
var timeText_1;
var text_3;
var vfBreakClock;
var text_27;
var key_resp_21;
var vocabExtendIntruxClock;
var vocabIntrux;
var key_resp_6;
var vocabAdvancedClock;
var vocabInstrux;
var sliderVocab;
var textStimVocab;
var key_resp_16;
var text_23;
var label1;
var label2;
var label3;
var label4;
var label5;
var countdown2Started;
var minutes2;
var seconds2;
var timeText2;
var timeText_3;
var vocabExtendClock;
var vInstrux;
var slider_extend;
var vocabCue;
var key_resp_24;
var text_41;
var r1;
var r2;
var r3;
var countdown3Started;
var minutes3;
var seconds3;
var timeText3;
var timeText_4;
var r_04;
var break99Clock;
var text_42;
var key_resp_25;
var FFinstruxClock;
var text_5;
var key_resp_8;
var FFoneClock;
var ffIntrux;
var ffprompt;
var text_6;
var text_8;
var last_resp;
var text_26;
var polygon;
var newWordClock;
var nBreak;
var FF2Clock;
var text_34;
var cue2;
var text_02;
var lastResp2;
var text_35;
var text_36;
var polygon_2;
var newWord2Clock;
var text_37;
var FFthreeClock;
var text_38;
var cue3;
var text_03;
var lastResp3;
var text_39;
var text_40;
var polygon_3;
var break4Clock;
var text_7;
var key_resp_9;
var autInstruxClock;
var text_43;
var key_resp_26;
var boxClock;
var text_44;
var text_45;
var box_resp;
var polygon_4;
var countdown8started;
var minutes8;
var seconds8;
var timeText8;
var box_time;
var nextAUTClock;
var text_46;
var ropeClock;
var text_47;
var text_48;
var rope_resp;
var polygon_5;
var countdown9started;
var minutes9;
var seconds9;
var timeText9;
var rope_time;
var catellInstruxClock;
var Catellinstrux;
var text_9;
var CattelExample;
var key_resp_10;
var dir2;
var GetReadyClock;
var text_10;
var CattelClock;
var sliderCattel;
var countdown4Started;
var cattellClock;
var timer2;
var key_resp_17;
var text_24;
var Img1;
var demoInstruxClock;
var text_11;
var key_resp_11;
var GenderClock;
var text_12;
var genderSlide;
var text_25;
var key_resp_22;
var AgeClock;
var ageQ;
var ageResp;
var text_29;
var EFLClock;
var eng;
var engSlide;
var text_28;
var key_resp_23;
var thanksClock;
var text_13;
var globalClock;
var routineTimer;
function experimentInit() {
  // Initialize components for Routine "welcome"
  welcomeClock = new util.Clock();
  Welcome = new visual.TextStim({
    win: psychoJS.window,
    name: 'Welcome',
    text: 'Welcome to the experiment!\n',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.4], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_49 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_49',
    text: 'We are asking you to take part in a research study that is being conducted through the Language and Aging Lab at the Pennsylvania State University. Research studies include only people who choose to take part. In order to decide whether or not you wish to be a part of this research study, you should know enough about its risks and benefits to make an informed judgment. The text below provides detailed information about the research study. If you agree to participate you should continue with the survey. If you would rather not participate please close this browser tab now.\n\nIn this study, you will be presented with words, asked to make decisions about words or pictures, and asked to type words. Instructions about the specific tasks will be provided on the following pages. It is expected that this study will take around 60 minutes. You may choose to end your participation at any time and will be paid for the number of items that you have completed.\n\nThere are no physical risks associated with this study, and there is no risk of loss of confidentiality as you are only identified by a code. This research study is of no direct benefit to you, however, this research will improve our knowledge about language and the brain.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  // Initialize components for Routine "SJTintrux"
  SJTintruxClock = new util.Clock();
  Intruxtext = new visual.TextStim({
    win: psychoJS.window,
    name: 'Intruxtext',
    text: 'For this set of questions you will be presented with two different words. Please rate how similar you believe these words are to each other on a scale of 0 (completely unrelated) to 1 (completely related). Try to give a quick, intuitive judgment without thinking too much about your answers.\n\nThere will be four blocks of questions, with breaks in between.  Please respond to all questions.\n\nPress enter when you are ready to begin. ',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.0], height: 0.04,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_2 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "SJT1"
  SJT1Clock = new util.Clock();
  slider = new visual.Slider({
    win: psychoJS.window, name: 'slider',
    size: [0.7, 0.15], pos: [0.03, (- 0.2)], units: 'height',
    labels: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1], ticks: [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0],
    granularity: 0, style: [visual.Slider.Style.RATING, visual.Slider.Style.TRIANGLE_MARKER],
    color: new util.Color('white'), 
    fontFamily: 'Arial', bold: true, italic: false, 
    flip: false,
  });
  
  pairs = new visual.TextStim({
    win: psychoJS.window,
    name: 'pairs',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  Unrelated = new visual.TextStim({
    win: psychoJS.window,
    name: 'Unrelated',
    text: 'UNRELATED',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.56), (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -2.0 
  });
  
  Related = new visual.TextStim({
    win: psychoJS.window,
    name: 'Related',
    text: 'RELATED',
    font: 'Arial',
    units: undefined, 
    pos: [0.58, (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -3.0 
  });
  
  key_resp_12 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_19 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_19',
    text: 'Slide the triangle, then press space after making a selection.',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.4)], height: 0.02,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  SJTcounter = 0;
  
  currVal1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'currVal1',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.03)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -7.0 
  });
  
  text_30 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_30',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.6, (- 0.4)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -8.0 
  });
  
  // Initialize components for Routine "break1"
  break1Clock = new util.Clock();
  text33 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text33',
    text: 'Break\n\nPress enter when you are ready to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_18 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "SJT2"
  SJT2Clock = new util.Clock();
  pairs1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'pairs1',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  slider_2 = new visual.Slider({
    win: psychoJS.window, name: 'slider_2',
    size: [0.7, 0.15], pos: [0.03, (- 0.2)], units: 'height',
    labels: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1], ticks: [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0],
    granularity: 0, style: [visual.Slider.Style.RATING, visual.Slider.Style.TRIANGLE_MARKER],
    color: new util.Color('white'), 
    fontFamily: 'Arial', bold: true, italic: false, 
    flip: false,
  });
  
  related1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'related1',
    text: 'RELATED',
    font: 'Arial',
    units: undefined, 
    pos: [0.58, (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -2.0 
  });
  
  unrelated1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'unrelated1',
    text: 'UNRELATED',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.56), (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -3.0 
  });
  
  key_resp_13 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_20 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_20',
    text: 'Slide the triangle, then press space after making a selection.',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.4)], height: 0.02,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  SJTcounter2 = 0;
  
  currVal2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'currVal2',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.03)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -7.0 
  });
  
  text_31 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_31',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.6, (- 0.4)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -8.0 
  });
  
  // Initialize components for Routine "stop2"
  stop2Clock = new util.Clock();
  text_14 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_14',
    text: 'Break\n\nPress enter when you are ready to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_19 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "SJT3"
  SJT3Clock = new util.Clock();
  text_15 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_15',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  slider_3 = new visual.Slider({
    win: psychoJS.window, name: 'slider_3',
    size: [0.7, 0.15], pos: [0.03, (- 0.2)], units: 'height',
    labels: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1], ticks: [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0],
    granularity: 0, style: [visual.Slider.Style.RATING, visual.Slider.Style.TRIANGLE_MARKER],
    color: new util.Color('white'), 
    fontFamily: 'Arial', bold: true, italic: false, 
    flip: false,
  });
  
  related2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'related2',
    text: 'RELATED',
    font: 'Arial',
    units: undefined, 
    pos: [0.58, (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -2.0 
  });
  
  unrelated2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'unrelated2',
    text: 'UNRELATED',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.56), (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -3.0 
  });
  
  key_resp_14 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_21 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_21',
    text: 'Slide the triangle, then press space after making a selection.',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.4)], height: 0.02,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  SJTcounter3 = 0;
  
  currVal3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'currVal3',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.03)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -7.0 
  });
  
  text_33 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_33',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.6, (- 0.4)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -8.0 
  });
  
  // Initialize components for Routine "stop3"
  stop3Clock = new util.Clock();
  text_16 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_16',
    text: 'Break\n\nPress enter to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_20 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "SJT4"
  SJT4Clock = new util.Clock();
  text_17 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_17',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  slider_4 = new visual.Slider({
    win: psychoJS.window, name: 'slider_4',
    size: [0.7, 0.15], pos: [0.03, (- 0.2)], units: 'height',
    labels: [0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1], ticks: [0.0, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0],
    granularity: 0, style: [visual.Slider.Style.RATING, visual.Slider.Style.TRIANGLE_MARKER],
    color: new util.Color('white'), 
    fontFamily: 'Arial', bold: true, italic: false, 
    flip: false,
  });
  
  related3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'related3',
    text: 'RELATED',
    font: 'Arial',
    units: undefined, 
    pos: [0.58, (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -2.0 
  });
  
  unrelated3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'unrelated3',
    text: 'UNRELATED',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.56), (- 0.2)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: -3.0 
  });
  
  key_resp_15 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_22 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_22',
    text: 'Slide the triangle, then press space after making a selection.',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.4)], height: 0.02,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  SJTcounter4 = 0;
  
  currVal4 = new visual.TextStim({
    win: psychoJS.window,
    name: 'currVal4',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.03, (- 0.03)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -7.0 
  });
  
  text_32 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_32',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.6, (- 0.4)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -8.0 
  });
  
  // Initialize components for Routine "breakNew"
  breakNewClock = new util.Clock();
  text_18 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_18',
    text: 'Good work!\n\nTake a break. \n\nPress enter when you are ready to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_3 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "VfluInstrux"
  VfluInstruxClock = new util.Clock();
  Instrux2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'Instrux2',
    text: '\n\nIn the next task, you will be given a category and asked to list as many items from that category as you can. For instance, if the category is instruments, you should list as many instruments as you can recall.\n\nDo not enter the same item twice, or the same root word with different suffixes. For example if you list "guitar", do not list "guitars" in the same round. \n\nYou will have 2 minutes to list as many items from the category as possible -- just press ENTER after each one.\n\nThere will be 2 categories in total.\n\n\nPress enter to start. ',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.04], height: 0.04,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_4 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "vf"
  vfClock = new util.Clock();
  category = new visual.TextStim({
    win: psychoJS.window,
    name: 'category',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.15], height: 0.08,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  text = new visual.TextStim({
    win: psychoJS.window,
    name: 'text',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.1)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  countdownStarted = false;
  minutes = "";
  seconds = "";
  timeText = "";
  
  timeText_1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'timeText_1',
    text: timeText,
    font: 'Arial',
    units: undefined, 
    pos: [0.5, (- 0.4)], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -3.0 
  });
  
  text_3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_3',
    text: 'Press Enter after each response.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.25)], height: 0.04,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  // Initialize components for Routine "vfBreak"
  vfBreakClock = new util.Clock();
  text_27 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_27',
    text: 'Break\n\nPress enter to continue',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_21 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "vocabExtendIntrux"
  vocabExtendIntruxClock = new util.Clock();
  vocabIntrux = new visual.TextStim({
    win: psychoJS.window,
    name: 'vocabIntrux',
    text: 'This next task measures knowledge of word meanings. \n\nYou will be presented with a word and asked to choose which word, out of 5 options, has the same meaning or nearly the same meaning. \n\nPlease select your answer by clicking the right answer with your mouse.\n\nYou will have 8 minutes to complete this task.\n\nPress enter to start. ',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.05], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_6 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "vocabAdvanced"
  vocabAdvancedClock = new util.Clock();
  vocabInstrux = new visual.TextStim({
    win: psychoJS.window,
    name: 'vocabInstrux',
    text: 'Select the word that has the same or nearly the same meaning. \n',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.3], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  sliderVocab = new visual.Slider({
    win: psychoJS.window, name: 'sliderVocab',
    size: [1.0, 0.05], pos: [0, (- 0.25)], units: 'height',
    labels: undefined, ticks: [1, 2, 3, 4, 5],
    granularity: 1, style: [visual.Slider.Style.SLIDER, visual.Slider.Style.RATING, visual.Slider.Style.RADIO],
    color: new util.Color('black'), 
    fontFamily: 'HelveticaBold', bold: true, italic: false, 
    flip: false,
  });
  
  textStimVocab = new visual.TextStim({
    win: psychoJS.window,
    name: 'textStimVocab',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.125,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  key_resp_16 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_23 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_23',
    text: 'Make selection, then press space to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.42)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  label1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'label1',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0.51, (- 0.35)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  label2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'label2',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0.26, (- 0.35)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -6.0 
  });
  
  label3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'label3',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.35)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -7.0 
  });
  
  label4 = new visual.TextStim({
    win: psychoJS.window,
    name: 'label4',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.26), (- 0.35)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -8.0 
  });
  
  label5 = new visual.TextStim({
    win: psychoJS.window,
    name: 'label5',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.51), (- 0.35)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -9.0 
  });
  
  countdown2Started = false;
  minutes2 = "";
  seconds2 = "";
  timeText2 = "";
  
  timeText_3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'timeText_3',
    text: timeText2,
    font: 'Arial',
    units: undefined, 
    pos: [0.54, (- 0.45)], height: 0.06,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -11.0 
  });
  
  // Initialize components for Routine "vocabExtend"
  vocabExtendClock = new util.Clock();
  vInstrux = new visual.TextStim({
    win: psychoJS.window,
    name: 'vInstrux',
    text: 'Select the word that has the same or nearly the same meaning. \n',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.3], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  slider_extend = new visual.Slider({
    win: psychoJS.window, name: 'slider_extend',
    size: [1.0, 0.05], pos: [0, (- 0.2)], units: 'height',
    labels: undefined, ticks: [1, 2, 3, 4],
    granularity: 1, style: [visual.Slider.Style.SLIDER, visual.Slider.Style.RATING, visual.Slider.Style.RADIO],
    color: new util.Color('black'), 
    fontFamily: 'HelveticaBold', bold: true, italic: false, 
    flip: false,
  });
  
  vocabCue = new visual.TextStim({
    win: psychoJS.window,
    name: 'vocabCue',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.125,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  key_resp_24 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_41 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_41',
    text: 'Make selection, then press space to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.42)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  r1 = new visual.TextStim({
    win: psychoJS.window,
    name: 'r1',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.51), (- 0.3)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  r2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'r2',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.16), (- 0.3)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -6.0 
  });
  
  r3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'r3',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0.16, (- 0.3)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -7.0 
  });
  
  countdown3Started = false;
  minutes3 = "";
  seconds3 = "";
  timeText3 = "";
  
  timeText_4 = new visual.TextStim({
    win: psychoJS.window,
    name: 'timeText_4',
    text: timeText2,
    font: 'Arial',
    units: undefined, 
    pos: [0.54, (- 0.45)], height: 0.06,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -9.0 
  });
  
  r_04 = new visual.TextStim({
    win: psychoJS.window,
    name: 'r_04',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0.51, (- 0.3)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -10.0 
  });
  
  // Initialize components for Routine "break99"
  break99Clock = new util.Clock();
  text_42 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_42',
    text: 'Break\n\nPress enter to continue',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_25 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "FFinstrux"
  FFinstruxClock = new util.Clock();
  text_5 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_5',
    text: 'For this next task you will be presented with a word and your job is to write the next word that comes to mind.\n\nThen write the next word that comes to mind from the word that you came up with.\n\nFor example, if you were given the word "brick", you might write building, hospital, optometrist, glasses, library, and so on.\n\nKeep going until you reach the maximum number of responses.  The experiment will automatically continue to the next word.\n\nPlease use only single words and no proper nouns. \n\n\nPress space when you are ready to begin. ',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.06], height: 0.04,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_8 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "FFone"
  FFoneClock = new util.Clock();
  ffIntrux = new visual.TextStim({
    win: psychoJS.window,
    name: 'ffIntrux',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.39], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  ffprompt = new visual.TextStim({
    win: psychoJS.window,
    name: 'ffprompt',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.28], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  text_6 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_6',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.1)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  ffprompt.text = "Pen";
  
  text_8 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_8',
    text: 'Press Enter once after each response.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.42)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  last_resp = new visual.TextStim({
    win: psychoJS.window,
    name: 'last_resp',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.2, 0.15], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  text_26 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_26',
    text: 'Last response:',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.3), 0.15], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -6.0 
  });
  
  polygon = new visual.ShapeStim ({
    win: psychoJS.window, name: 'polygon', 
    vertices: [[-[1.25, 0.05][0]/2.0, 0], [+[1.25, 0.05][0]/2.0, 0]],
    ori: 0, pos: [0, 0.1],
    lineWidth: 1, lineColor: new util.Color([1, 1, 1]),
    fillColor: new util.Color([1, 1, 1]),
    opacity: 1, depth: -7, interpolate: true,
  });
  
  // Initialize components for Routine "newWord"
  newWordClock = new util.Clock();
  nBreak = new visual.TextStim({
    win: psychoJS.window,
    name: 'nBreak',
    text: 'New word!\n\nBelt',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  // Initialize components for Routine "FF2"
  FF2Clock = new util.Clock();
  text_34 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_34',
    text: 'Beginning with the following word, write the next word that comes to mind from the previous word.  Please use only single words and proper nouns.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.39], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  cue2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'cue2',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.29], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  text_02 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_02',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.1)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  cue2.text = "Belt";
  
  lastResp2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'lastResp2',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.2, 0.15], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  text_35 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_35',
    text: 'Last response:',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.3), 0.15], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  text_36 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_36',
    text: 'Press enter once after each response.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.42)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -6.0 
  });
  
  polygon_2 = new visual.ShapeStim ({
    win: psychoJS.window, name: 'polygon_2', 
    vertices: [[-[1.25, 0.05][0]/2.0, 0], [+[1.25, 0.05][0]/2.0, 0]],
    ori: 0, pos: [0, 0.1],
    lineWidth: 1, lineColor: new util.Color([1, 1, 1]),
    fillColor: new util.Color([1, 1, 1]),
    opacity: 1, depth: -7, interpolate: true,
  });
  
  // Initialize components for Routine "newWord2"
  newWord2Clock = new util.Clock();
  text_37 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_37',
    text: 'New Word!\n\nLadder',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  // Initialize components for Routine "FFthree"
  FFthreeClock = new util.Clock();
  text_38 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_38',
    text: 'Beginning with the following word, write the next word that comes to mind from the previous word.  Please use only single words and proper nouns.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.39], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  cue3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'cue3',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.29], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  text_03 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_03',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.1)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  cue3.text = "Ladder";
  
  lastResp3 = new visual.TextStim({
    win: psychoJS.window,
    name: 'lastResp3',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.2, 0.15], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  text_39 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_39',
    text: 'Last response:',
    font: 'Arial',
    units: undefined, 
    pos: [(- 0.3), 0.15], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  text_40 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_40',
    text: 'Press Enter once after each response.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.42)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -6.0 
  });
  
  polygon_3 = new visual.ShapeStim ({
    win: psychoJS.window, name: 'polygon_3', 
    vertices: [[-[1.25, 0.05][0]/2.0, 0], [+[1.25, 0.05][0]/2.0, 0]],
    ori: 0, pos: [0, 0.1],
    lineWidth: 1, lineColor: new util.Color([1, 1, 1]),
    fillColor: new util.Color([1, 1, 1]),
    opacity: 1, depth: -7, interpolate: true,
  });
  
  // Initialize components for Routine "break4"
  break4Clock = new util.Clock();
  text_7 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_7',
    text: 'Break\n\nPress enter when you are ready to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_9 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "autInstrux"
  autInstruxClock = new util.Clock();
  text_43 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_43',
    text: "For the next task, you''ll be asked to come up with as many original and creative uses for objects as you can.\n\nThe goal is to come up with *creative ideas*, which are ideas that strike people as clever, unusual, interesting, uncommon, humorous, innovative, or different.\n\nYou will be asked to type uses for 10 different objects. \n\nPlease try to keep your responses short. \n\nYou will have 2 minutes to type as many creative uses for each object as you can.\n\nPress Enter to begin.",
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_26 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "box"
  boxClock = new util.Clock();
  text_44 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_44',
    text: 'Creative uses for:',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.4], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  text_45 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_45',
    text: 'BOX',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.3], height: 0.06,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  box_resp = new visual.TextStim({
    win: psychoJS.window,
    name: 'box_resp',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  polygon_4 = new visual.ShapeStim ({
    win: psychoJS.window, name: 'polygon_4', 
    vertices: [[-[1.25, 0.25][0]/2.0, 0], [+[1.25, 0.25][0]/2.0, 0]],
    ori: 0, pos: [0, (- 0.05)],
    lineWidth: 1, lineColor: new util.Color([1, 1, 1]),
    fillColor: new util.Color([1, 1, 1]),
    opacity: 1, depth: -3, interpolate: true,
  });
  
  countdown8started = false;
  minutes8 = "";
  seconds8 = "";
  timeText8 = "";
  
  box_time = new visual.TextStim({
    win: psychoJS.window,
    name: 'box_time',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.5, (- 0.4)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  // Initialize components for Routine "nextAUT"
  nextAUTClock = new util.Clock();
  text_46 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_46',
    text: 'New word!',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  // Initialize components for Routine "rope"
  ropeClock = new util.Clock();
  text_47 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_47',
    text: 'Creative uses for: ',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.4], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  text_48 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_48',
    text: 'ROPE',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.3], height: 0.06,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  rope_resp = new visual.TextStim({
    win: psychoJS.window,
    name: 'rope_resp',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  polygon_5 = new visual.ShapeStim ({
    win: psychoJS.window, name: 'polygon_5', 
    vertices: [[-[1.25, 0.25][0]/2.0, 0], [+[1.25, 0.25][0]/2.0, 0]],
    ori: 0, pos: [0, (- 0.05)],
    lineWidth: 1, lineColor: new util.Color([1, 1, 1]),
    fillColor: new util.Color([1, 1, 1]),
    opacity: 1, depth: -3, interpolate: true,
  });
  
  countdown9started = false;
  minutes9 = "";
  seconds9 = "";
  timeText9 = "";
  
  rope_time = new visual.TextStim({
    win: psychoJS.window,
    name: 'rope_time',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0.5, (- 0.4)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -5.0 
  });
  
  // Initialize components for Routine "catellInstrux"
  catellInstruxClock = new util.Clock();
  Catellinstrux = new visual.TextStim({
    win: psychoJS.window,
    name: 'Catellinstrux',
    text: 'For the following task, you will be presented with a series of drawings contained within a row of boxes. \nThe last box in the series will be empty with dotted lines around the border. \nThe row of boxes to the right of the sample are the answer choices: One of these correctly completes the series. \n\nLook at the example below. ',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.25], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  text_9 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_9',
    text: 'Press Enter to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.4)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  CattelExample = new visual.ImageStim({
    win : psychoJS.window,
    name : 'CattelExample', units : undefined, 
    image : 'CattelExample.png', mask : undefined,
    ori : 0, pos : [0, 0.061], size : [1, 0.1],
    color : new util.Color([1, 1, 1]), opacity : 1,
    flipHoriz : false, flipVert : false,
    texRes : 128, interpolate : true, depth : -2.0 
  });
  key_resp_10 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  dir2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'dir2',
    text: 'Answer choice "E" correctly completes this series.\n\nYou will have 3 minutes for this task, with a clock counting down at the bottom of the screen. \nAfter three minutes elapse, you will automatically move on to the next part.  \n',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.19)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  // Initialize components for Routine "GetReady"
  GetReadyClock = new util.Clock();
  text_10 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_10',
    text: 'Get ready!',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  // Initialize components for Routine "Cattel"
  CattelClock = new util.Clock();
  sliderCattel = new visual.Slider({
    win: psychoJS.window, name: 'sliderCattel',
    size: [1.0, 0.06], pos: [0, (- 0.1)], units: 'height',
    labels: ['A', 'B', 'C', 'D', 'E', 'F'], ticks: [1, 2, 3, 4, 5, 6],
    granularity: 1, style: [visual.Slider.Style.SLIDER, visual.Slider.Style.RATING, visual.Slider.Style.RADIO],
    color: new util.Color('black'), 
    fontFamily: 'HelveticaBold', bold: true, italic: false, 
    flip: false,
  });
  
  countdown4Started = false;
  cattellClock = "";
  
  timer2 = new visual.TextStim({
    win: psychoJS.window,
    name: 'timer2',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0.45, (- 0.4)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  key_resp_17 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  text_24 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_24',
    text: 'Make selection, then press space to continue.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.4)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -4.0 
  });
  
  Img1 = new visual.ImageStim({
    win : psychoJS.window,
    name : 'Img1', units : undefined, 
    image : undefined, mask : undefined,
    ori : 0, pos : [0, 0.24], size : [1, 0.18],
    color : new util.Color([1.0, 1.0, 1.0]), opacity : 1,
    flipHoriz : false, flipVert : false,
    texRes : 128, interpolate : true, depth : -5.0 
  });
  // Initialize components for Routine "demoInstrux"
  demoInstruxClock = new util.Clock();
  text_11 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_11',
    text: 'You have now completed the main tasks. \n\nAll that remains is a few questions about you. \n\nPress enter to begin.',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.1], height: 0.07,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  key_resp_11 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "Gender"
  GenderClock = new util.Clock();
  text_12 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_12',
    text: 'default text',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.3], height: 0.08,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  genderSlide = new visual.Slider({
    win: psychoJS.window, name: 'genderSlide',
    size: [1.0, 0.05], pos: [0, (- 0.2)], units: 'height',
    labels: ['Male', 'Female', 'Non binary', 'Prefer not to say'], ticks: [1, 2, 3, 4],
    granularity: 1, style: [visual.Slider.Style.SLIDER, visual.Slider.Style.RATING, visual.Slider.Style.RADIO],
    color: new util.Color('black'), 
    fontFamily: 'HelveticaBold', bold: true, italic: false, 
    flip: false,
  });
  
  text_25 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_25',
    text: 'Select response, then press enter.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.4)], height: 0.04,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  key_resp_22 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "Age"
  AgeClock = new util.Clock();
  ageQ = new visual.TextStim({
    win: psychoJS.window,
    name: 'ageQ',
    text: 'What is your age?',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  ageResp = new visual.TextStim({
    win: psychoJS.window,
    name: 'ageResp',
    text: '',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -1.0 
  });
  
  text_29 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_29',
    text: 'Type your age, then press enter.',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.3)], height: 0.03,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -3.0 
  });
  
  // Initialize components for Routine "EFL"
  EFLClock = new util.Clock();
  eng = new visual.TextStim({
    win: psychoJS.window,
    name: 'eng',
    text: 'Is English your first language?',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0.2], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: 0.0 
  });
  
  engSlide = new visual.Slider({
    win: psychoJS.window, name: 'engSlide',
    size: [0.4, 0.07], pos: [0, (- 0.1)], units: 'height',
    labels: ['Yes', 'No'], ticks: [0, 1],
    granularity: 1, style: [visual.Slider.Style.SLIDER, visual.Slider.Style.RATING, visual.Slider.Style.RADIO],
    color: new util.Color('black'), 
    fontFamily: 'HelveticaBold', bold: true, italic: false, 
    flip: false,
  });
  
  text_28 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_28',
    text: 'Make selection, then press Enter. ',
    font: 'Arial',
    units: undefined, 
    pos: [0, (- 0.3)], height: 0.05,  wrapWidth: undefined, ori: 0,
    color: new util.Color('white'),  opacity: 1,
    depth: -2.0 
  });
  
  key_resp_23 = new core.Keyboard({psychoJS: psychoJS, clock: new util.Clock(), waitForStart: true});
  
  // Initialize components for Routine "thanks"
  thanksClock = new util.Clock();
  text_13 = new visual.TextStim({
    win: psychoJS.window,
    name: 'text_13',
    text: 'Thank you for participating. \n\nThe experiment will close shortly.\n',
    font: 'Arial',
    units: undefined, 
    pos: [0, 0], height: 0.1,  wrapWidth: undefined, ori: 0,
    color: new util.Color('lightblue'),  opacity: 1,
    depth: 0.0 
  });
  
  // Create some handy timers
  globalClock = new util.Clock();  // to track the time since experiment started
  routineTimer = new util.CountdownTimer();  // to track time remaining of each (non-slip) routine
  
  return Scheduler.Event.NEXT;
}


var t;
var frameN;
var _key_resp_allKeys;
var welcomeComponents;
function welcomeRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'welcome'-------
    t = 0;
    welcomeClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp.keys = undefined;
    key_resp.rt = undefined;
    _key_resp_allKeys = [];
    // keep track of which components have finished
    welcomeComponents = [];
    welcomeComponents.push(Welcome);
    welcomeComponents.push(key_resp);
    welcomeComponents.push(text_49);
    
    for (const thisComponent of welcomeComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var continueRoutine;
function welcomeRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'welcome'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = welcomeClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *Welcome* updates
    if (t >= 0.0 && Welcome.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Welcome.tStart = t;  // (not accounting for frame time here)
      Welcome.frameNStart = frameN;  // exact frame index
      
      Welcome.setAutoDraw(true);
    }

    
    // *key_resp* updates
    if (t >= 2 && key_resp.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp.tStart = t;  // (not accounting for frame time here)
      key_resp.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp.clearEvents(); });
    }

    if (key_resp.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_allKeys = _key_resp_allKeys.concat(theseKeys);
      if (_key_resp_allKeys.length > 0) {
        key_resp.keys = _key_resp_allKeys[_key_resp_allKeys.length - 1].name;  // just the last key pressed
        key_resp.rt = _key_resp_allKeys[_key_resp_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_49* updates
    if (t >= 0.0 && text_49.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_49.tStart = t;  // (not accounting for frame time here)
      text_49.frameNStart = frameN;  // exact frame index
      
      text_49.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of welcomeComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function welcomeRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'welcome'-------
    for (const thisComponent of welcomeComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "welcome" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_2_allKeys;
var SJTintruxComponents;
function SJTintruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'SJTintrux'-------
    t = 0;
    SJTintruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_2.keys = undefined;
    key_resp_2.rt = undefined;
    _key_resp_2_allKeys = [];
    // keep track of which components have finished
    SJTintruxComponents = [];
    SJTintruxComponents.push(Intruxtext);
    SJTintruxComponents.push(key_resp_2);
    
    for (const thisComponent of SJTintruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function SJTintruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'SJTintrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = SJTintruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *Intruxtext* updates
    if (t >= 0.0 && Intruxtext.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Intruxtext.tStart = t;  // (not accounting for frame time here)
      Intruxtext.frameNStart = frameN;  // exact frame index
      
      Intruxtext.setAutoDraw(true);
    }

    
    // *key_resp_2* updates
    if (t >= 3 && key_resp_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_2.tStart = t;  // (not accounting for frame time here)
      key_resp_2.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_2.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_2.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_2.clearEvents(); });
    }

    if (key_resp_2.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_2.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_2_allKeys = _key_resp_2_allKeys.concat(theseKeys);
      if (_key_resp_2_allKeys.length > 0) {
        key_resp_2.keys = _key_resp_2_allKeys[_key_resp_2_allKeys.length - 1].name;  // just the last key pressed
        key_resp_2.rt = _key_resp_2_allKeys[_key_resp_2_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of SJTintruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function SJTintruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'SJTintrux'-------
    for (const thisComponent of SJTintruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "SJTintrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var trials_01;
var currentLoop;
function trials_01LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_01 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'pairs_combined.csv',
    seed: undefined, name: 'trials_01'
  });
  psychoJS.experiment.addLoop(trials_01); // add the loop to the experiment
  currentLoop = trials_01;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_01 of trials_01) {
    const snapshot = trials_01.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(SJT1RoutineBegin(snapshot));
    thisScheduler.add(SJT1RoutineEachFrame(snapshot));
    thisScheduler.add(SJT1RoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_01LoopEnd() {
  psychoJS.experiment.removeLoop(trials_01);

  return Scheduler.Event.NEXT;
}


var trials_9;
function trials_9LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_9 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'combined1.xlsx',
    seed: undefined, name: 'trials_9'
  });
  psychoJS.experiment.addLoop(trials_9); // add the loop to the experiment
  currentLoop = trials_9;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_9 of trials_9) {
    const snapshot = trials_9.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(SJT2RoutineBegin(snapshot));
    thisScheduler.add(SJT2RoutineEachFrame(snapshot));
    thisScheduler.add(SJT2RoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_9LoopEnd() {
  psychoJS.experiment.removeLoop(trials_9);

  return Scheduler.Event.NEXT;
}


var trials_10;
function trials_10LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_10 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'combined2.xlsx',
    seed: undefined, name: 'trials_10'
  });
  psychoJS.experiment.addLoop(trials_10); // add the loop to the experiment
  currentLoop = trials_10;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_10 of trials_10) {
    const snapshot = trials_10.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(SJT3RoutineBegin(snapshot));
    thisScheduler.add(SJT3RoutineEachFrame(snapshot));
    thisScheduler.add(SJT3RoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_10LoopEnd() {
  psychoJS.experiment.removeLoop(trials_10);

  return Scheduler.Event.NEXT;
}


var trials_11;
function trials_11LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_11 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'combined3.xlsx',
    seed: undefined, name: 'trials_11'
  });
  psychoJS.experiment.addLoop(trials_11); // add the loop to the experiment
  currentLoop = trials_11;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_11 of trials_11) {
    const snapshot = trials_11.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(SJT4RoutineBegin(snapshot));
    thisScheduler.add(SJT4RoutineEachFrame(snapshot));
    thisScheduler.add(SJT4RoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_11LoopEnd() {
  psychoJS.experiment.removeLoop(trials_11);

  return Scheduler.Event.NEXT;
}


var trials_3;
function trials_3LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_3 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.SEQUENTIAL,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'VFconds.xlsx',
    seed: undefined, name: 'trials_3'
  });
  psychoJS.experiment.addLoop(trials_3); // add the loop to the experiment
  currentLoop = trials_3;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_3 of trials_3) {
    const snapshot = trials_3.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    const trials_2LoopScheduler = new Scheduler(psychoJS);
    thisScheduler.add(trials_2LoopBegin, trials_2LoopScheduler);
    thisScheduler.add(trials_2LoopScheduler);
    thisScheduler.add(trials_2LoopEnd);
    thisScheduler.add(vfBreakRoutineBegin(snapshot));
    thisScheduler.add(vfBreakRoutineEachFrame(snapshot));
    thisScheduler.add(vfBreakRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


var trials_2;
function trials_2LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_2 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 300, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: undefined,
    seed: undefined, name: 'trials_2'
  });
  psychoJS.experiment.addLoop(trials_2); // add the loop to the experiment
  currentLoop = trials_2;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_2 of trials_2) {
    const snapshot = trials_2.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(vfRoutineBegin(snapshot));
    thisScheduler.add(vfRoutineEachFrame(snapshot));
    thisScheduler.add(vfRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_2LoopEnd() {
  psychoJS.experiment.removeLoop(trials_2);

  return Scheduler.Event.NEXT;
}


function trials_3LoopEnd() {
  psychoJS.experiment.removeLoop(trials_3);

  return Scheduler.Event.NEXT;
}


var trials_4;
function trials_4LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_4 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.SEQUENTIAL,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'Vocab.xlsx',
    seed: undefined, name: 'trials_4'
  });
  psychoJS.experiment.addLoop(trials_4); // add the loop to the experiment
  currentLoop = trials_4;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_4 of trials_4) {
    const snapshot = trials_4.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(vocabAdvancedRoutineBegin(snapshot));
    thisScheduler.add(vocabAdvancedRoutineEachFrame(snapshot));
    thisScheduler.add(vocabAdvancedRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_4LoopEnd() {
  psychoJS.experiment.removeLoop(trials_4);

  return Scheduler.Event.NEXT;
}


var extendTrials;
function extendTrialsLoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  extendTrials = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.SEQUENTIAL,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'Vocab2.xlsx',
    seed: undefined, name: 'extendTrials'
  });
  psychoJS.experiment.addLoop(extendTrials); // add the loop to the experiment
  currentLoop = extendTrials;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisExtendTrial of extendTrials) {
    const snapshot = extendTrials.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(vocabExtendRoutineBegin(snapshot));
    thisScheduler.add(vocabExtendRoutineEachFrame(snapshot));
    thisScheduler.add(vocabExtendRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function extendTrialsLoopEnd() {
  psychoJS.experiment.removeLoop(extendTrials);

  return Scheduler.Event.NEXT;
}


var trials_29;
function trials_29LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_29 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 19, method: TrialHandler.Method.SEQUENTIAL,
    extraInfo: expInfo, originPath: undefined,
    trialList: undefined,
    seed: undefined, name: 'trials_29'
  });
  psychoJS.experiment.addLoop(trials_29); // add the loop to the experiment
  currentLoop = trials_29;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_29 of trials_29) {
    const snapshot = trials_29.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(FFoneRoutineBegin(snapshot));
    thisScheduler.add(FFoneRoutineEachFrame(snapshot));
    thisScheduler.add(FFoneRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_29LoopEnd() {
  psychoJS.experiment.removeLoop(trials_29);

  return Scheduler.Event.NEXT;
}


var trials_30;
function trials_30LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_30 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 19, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: undefined,
    seed: undefined, name: 'trials_30'
  });
  psychoJS.experiment.addLoop(trials_30); // add the loop to the experiment
  currentLoop = trials_30;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_30 of trials_30) {
    const snapshot = trials_30.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(FF2RoutineBegin(snapshot));
    thisScheduler.add(FF2RoutineEachFrame(snapshot));
    thisScheduler.add(FF2RoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_30LoopEnd() {
  psychoJS.experiment.removeLoop(trials_30);

  return Scheduler.Event.NEXT;
}


var trials_31;
function trials_31LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_31 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 19, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: undefined,
    seed: undefined, name: 'trials_31'
  });
  psychoJS.experiment.addLoop(trials_31); // add the loop to the experiment
  currentLoop = trials_31;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_31 of trials_31) {
    const snapshot = trials_31.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(FFthreeRoutineBegin(snapshot));
    thisScheduler.add(FFthreeRoutineEachFrame(snapshot));
    thisScheduler.add(FFthreeRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_31LoopEnd() {
  psychoJS.experiment.removeLoop(trials_31);

  return Scheduler.Event.NEXT;
}


var boxTrials;
function boxTrialsLoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  boxTrials = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 99, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: undefined,
    seed: undefined, name: 'boxTrials'
  });
  psychoJS.experiment.addLoop(boxTrials); // add the loop to the experiment
  currentLoop = boxTrials;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisBoxTrial of boxTrials) {
    const snapshot = boxTrials.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(boxRoutineBegin(snapshot));
    thisScheduler.add(boxRoutineEachFrame(snapshot));
    thisScheduler.add(boxRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function boxTrialsLoopEnd() {
  psychoJS.experiment.removeLoop(boxTrials);

  return Scheduler.Event.NEXT;
}


var ropeTrials;
function ropeTrialsLoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  ropeTrials = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 99, method: TrialHandler.Method.RANDOM,
    extraInfo: expInfo, originPath: undefined,
    trialList: undefined,
    seed: undefined, name: 'ropeTrials'
  });
  psychoJS.experiment.addLoop(ropeTrials); // add the loop to the experiment
  currentLoop = ropeTrials;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisRopeTrial of ropeTrials) {
    const snapshot = ropeTrials.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(ropeRoutineBegin(snapshot));
    thisScheduler.add(ropeRoutineEachFrame(snapshot));
    thisScheduler.add(ropeRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function ropeTrialsLoopEnd() {
  psychoJS.experiment.removeLoop(ropeTrials);

  return Scheduler.Event.NEXT;
}


var trials_7;
function trials_7LoopBegin(thisScheduler) {
  // set up handler to look after randomisation of conditions etc
  trials_7 = new TrialHandler({
    psychoJS: psychoJS,
    nReps: 1, method: TrialHandler.Method.SEQUENTIAL,
    extraInfo: expInfo, originPath: undefined,
    trialList: 'Cattel.xlsx',
    seed: undefined, name: 'trials_7'
  });
  psychoJS.experiment.addLoop(trials_7); // add the loop to the experiment
  currentLoop = trials_7;  // we're now the current loop

  // Schedule all the trials in the trialList:
  for (const thisTrial_7 of trials_7) {
    const snapshot = trials_7.getSnapshot();
    thisScheduler.add(importConditions(snapshot));
    thisScheduler.add(CattelRoutineBegin(snapshot));
    thisScheduler.add(CattelRoutineEachFrame(snapshot));
    thisScheduler.add(CattelRoutineEnd(snapshot));
    thisScheduler.add(endLoopIteration(thisScheduler, snapshot));
  }

  return Scheduler.Event.NEXT;
}


function trials_7LoopEnd() {
  psychoJS.experiment.removeLoop(trials_7);

  return Scheduler.Event.NEXT;
}


var _key_resp_12_allKeys;
var markerSize;
var slide1rating;
var slide1rt;
var SJT1Components;
function SJT1RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'SJT1'-------
    t = 0;
    SJT1Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    slider.reset()
    pairs.setText(combined);
    key_resp_12.keys = undefined;
    key_resp_12.rt = undefined;
    _key_resp_12_allKeys = [];
    slider.size[1] = (slider.size[1] / 2);
    slider._applyStyle();
    markerSize = util.to_px(slider.size, "height", psychoJS.window)[1];
    slider.markerPos = 0.5;
    SJTcounter = (SJTcounter + 1);
    text_30.text = ((SJTcounter.toString() + " of") + " 94");
    slide1rating = "";
    slide1rt = "";
    
    // keep track of which components have finished
    SJT1Components = [];
    SJT1Components.push(slider);
    SJT1Components.push(pairs);
    SJT1Components.push(Unrelated);
    SJT1Components.push(Related);
    SJT1Components.push(key_resp_12);
    SJT1Components.push(text_19);
    SJT1Components.push(currVal1);
    SJT1Components.push(text_30);
    
    for (const thisComponent of SJT1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var cVal1;
function SJT1RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'SJT1'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = SJT1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *slider* updates
    if (t >= 0 && slider.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      slider.tStart = t;  // (not accounting for frame time here)
      slider.frameNStart = frameN;  // exact frame index
      
      slider.setAutoDraw(true);
    }

    
    // *pairs* updates
    if (t >= 0.0 && pairs.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      pairs.tStart = t;  // (not accounting for frame time here)
      pairs.frameNStart = frameN;  // exact frame index
      
      pairs.setAutoDraw(true);
    }

    
    // *Unrelated* updates
    if (t >= 0.0 && Unrelated.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Unrelated.tStart = t;  // (not accounting for frame time here)
      Unrelated.frameNStart = frameN;  // exact frame index
      
      Unrelated.setAutoDraw(true);
    }

    
    // *Related* updates
    if (t >= 0.0 && Related.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Related.tStart = t;  // (not accounting for frame time here)
      Related.frameNStart = frameN;  // exact frame index
      
      Related.setAutoDraw(true);
    }

    
    // *key_resp_12* updates
    if (t >= 0 && key_resp_12.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_12.tStart = t;  // (not accounting for frame time here)
      key_resp_12.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_12.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_12.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_12.clearEvents(); });
    }

    if (key_resp_12.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_12.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_12_allKeys = _key_resp_12_allKeys.concat(theseKeys);
      if (_key_resp_12_allKeys.length > 0) {
        key_resp_12.keys = _key_resp_12_allKeys[_key_resp_12_allKeys.length - 1].name;  // just the last key pressed
        key_resp_12.rt = _key_resp_12_allKeys[_key_resp_12_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_19* updates
    if (t >= 0.0 && text_19.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_19.tStart = t;  // (not accounting for frame time here)
      text_19.frameNStart = frameN;  // exact frame index
      
      text_19.setAutoDraw(true);
    }

    cVal1 = slider.markerPos;
    currVal1.text = (Math.round((cVal1 * 100.0)) / 100.0);
    
    
    // *currVal1* updates
    if (t >= 0.0 && currVal1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      currVal1.tStart = t;  // (not accounting for frame time here)
      currVal1.frameNStart = frameN;  // exact frame index
      
      currVal1.setAutoDraw(true);
    }

    
    // *text_30* updates
    if (t >= 0.0 && text_30.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_30.tStart = t;  // (not accounting for frame time here)
      text_30.frameNStart = frameN;  // exact frame index
      
      text_30.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of SJT1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function SJT1RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'SJT1'-------
    for (const thisComponent of SJT1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('slider.response', slider.getRating());
    psychoJS.experiment.addData('slider.rt', slider.getRT());
    slide1rating = slider.getRating();
    slide1rt = slider.getRT();
    trials_01.addData("slider1val", slide1rating);
    trials_01.addData("slider1RT", slide1rt);
    
    // the Routine "SJT1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_18_allKeys;
var break1Components;
function break1RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'break1'-------
    t = 0;
    break1Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_18.keys = undefined;
    key_resp_18.rt = undefined;
    _key_resp_18_allKeys = [];
    // keep track of which components have finished
    break1Components = [];
    break1Components.push(text33);
    break1Components.push(key_resp_18);
    
    for (const thisComponent of break1Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function break1RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'break1'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = break1Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text33* updates
    if (t >= 0 && text33.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text33.tStart = t;  // (not accounting for frame time here)
      text33.frameNStart = frameN;  // exact frame index
      
      text33.setAutoDraw(true);
    }

    
    // *key_resp_18* updates
    if (t >= 0.0 && key_resp_18.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_18.tStart = t;  // (not accounting for frame time here)
      key_resp_18.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_18.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_18.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_18.clearEvents(); });
    }

    if (key_resp_18.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_18.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_18_allKeys = _key_resp_18_allKeys.concat(theseKeys);
      if (_key_resp_18_allKeys.length > 0) {
        key_resp_18.keys = _key_resp_18_allKeys[_key_resp_18_allKeys.length - 1].name;  // just the last key pressed
        key_resp_18.rt = _key_resp_18_allKeys[_key_resp_18_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of break1Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function break1RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'break1'-------
    for (const thisComponent of break1Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "break1" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_13_allKeys;
var slide2rating;
var slide2rt;
var SJT2Components;
function SJT2RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'SJT2'-------
    t = 0;
    SJT2Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    pairs1.setText(combined1);
    slider_2.reset()
    key_resp_13.keys = undefined;
    key_resp_13.rt = undefined;
    _key_resp_13_allKeys = [];
    slider_2.size[1] = (slider_2.size[1] / 2);
    slider_2._applyStyle();
    markerSize = util.to_px(slider_2.size, "height", psychoJS.window)[1];
    slider_2.markerPos = 0.5;
    SJTcounter2 = (SJTcounter2 + 1);
    text_31.text = ((SJTcounter2.toString() + " of") + " 107");
    slide2rating = "";
    slide2rt = "";
    
    // keep track of which components have finished
    SJT2Components = [];
    SJT2Components.push(pairs1);
    SJT2Components.push(slider_2);
    SJT2Components.push(related1);
    SJT2Components.push(unrelated1);
    SJT2Components.push(key_resp_13);
    SJT2Components.push(text_20);
    SJT2Components.push(currVal2);
    SJT2Components.push(text_31);
    
    for (const thisComponent of SJT2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var cVal2;
function SJT2RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'SJT2'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = SJT2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *pairs1* updates
    if (t >= 0.0 && pairs1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      pairs1.tStart = t;  // (not accounting for frame time here)
      pairs1.frameNStart = frameN;  // exact frame index
      
      pairs1.setAutoDraw(true);
    }

    
    // *slider_2* updates
    if (t >= 0.0 && slider_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      slider_2.tStart = t;  // (not accounting for frame time here)
      slider_2.frameNStart = frameN;  // exact frame index
      
      slider_2.setAutoDraw(true);
    }

    
    // *related1* updates
    if (t >= 0.0 && related1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      related1.tStart = t;  // (not accounting for frame time here)
      related1.frameNStart = frameN;  // exact frame index
      
      related1.setAutoDraw(true);
    }

    
    // *unrelated1* updates
    if (t >= 0.0 && unrelated1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      unrelated1.tStart = t;  // (not accounting for frame time here)
      unrelated1.frameNStart = frameN;  // exact frame index
      
      unrelated1.setAutoDraw(true);
    }

    
    // *key_resp_13* updates
    if (t >= 0 && key_resp_13.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_13.tStart = t;  // (not accounting for frame time here)
      key_resp_13.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_13.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_13.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_13.clearEvents(); });
    }

    if (key_resp_13.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_13.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_13_allKeys = _key_resp_13_allKeys.concat(theseKeys);
      if (_key_resp_13_allKeys.length > 0) {
        key_resp_13.keys = _key_resp_13_allKeys[_key_resp_13_allKeys.length - 1].name;  // just the last key pressed
        key_resp_13.rt = _key_resp_13_allKeys[_key_resp_13_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_20* updates
    if (t >= 0.0 && text_20.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_20.tStart = t;  // (not accounting for frame time here)
      text_20.frameNStart = frameN;  // exact frame index
      
      text_20.setAutoDraw(true);
    }

    cVal2 = slider_2.markerPos;
    currVal2.text = (Math.round((cVal2 * 100.0)) / 100.0);
    
    
    // *currVal2* updates
    if (t >= 0.0 && currVal2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      currVal2.tStart = t;  // (not accounting for frame time here)
      currVal2.frameNStart = frameN;  // exact frame index
      
      currVal2.setAutoDraw(true);
    }

    
    // *text_31* updates
    if (t >= 0.0 && text_31.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_31.tStart = t;  // (not accounting for frame time here)
      text_31.frameNStart = frameN;  // exact frame index
      
      text_31.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of SJT2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function SJT2RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'SJT2'-------
    for (const thisComponent of SJT2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('slider_2.response', slider_2.getRating());
    psychoJS.experiment.addData('slider_2.rt', slider_2.getRT());
    slide2rating = slider_2.getRating();
    slide2rt = slider_2.getRT();
    trials_9.addData("slider2val", slide2rating);
    trials_9.addData("slider2RT", slide2rt);
    
    // the Routine "SJT2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_19_allKeys;
var stop2Components;
function stop2RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'stop2'-------
    t = 0;
    stop2Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_19.keys = undefined;
    key_resp_19.rt = undefined;
    _key_resp_19_allKeys = [];
    // keep track of which components have finished
    stop2Components = [];
    stop2Components.push(text_14);
    stop2Components.push(key_resp_19);
    
    for (const thisComponent of stop2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function stop2RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'stop2'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = stop2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_14* updates
    if (t >= 0.0 && text_14.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_14.tStart = t;  // (not accounting for frame time here)
      text_14.frameNStart = frameN;  // exact frame index
      
      text_14.setAutoDraw(true);
    }

    
    // *key_resp_19* updates
    if (t >= 0.0 && key_resp_19.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_19.tStart = t;  // (not accounting for frame time here)
      key_resp_19.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_19.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_19.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_19.clearEvents(); });
    }

    if (key_resp_19.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_19.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_19_allKeys = _key_resp_19_allKeys.concat(theseKeys);
      if (_key_resp_19_allKeys.length > 0) {
        key_resp_19.keys = _key_resp_19_allKeys[_key_resp_19_allKeys.length - 1].name;  // just the last key pressed
        key_resp_19.rt = _key_resp_19_allKeys[_key_resp_19_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of stop2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function stop2RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'stop2'-------
    for (const thisComponent of stop2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "stop2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_14_allKeys;
var slide3rating;
var slide3rt;
var SJT3Components;
function SJT3RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'SJT3'-------
    t = 0;
    SJT3Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    text_15.setText(combined2);
    slider_3.reset()
    key_resp_14.keys = undefined;
    key_resp_14.rt = undefined;
    _key_resp_14_allKeys = [];
    slider_3.size[1] = (slider_3.size[1] / 2);
    slider_3._applyStyle();
    markerSize = util.to_px(slider_3.size, "height", psychoJS.window)[1];
    slider_3.markerPos = 0.5;
    SJTcounter3 = (SJTcounter3 + 1);
    text_33.text = ((SJTcounter3.toString() + " of") + " 104");
    slide3rating = "";
    slide3rt = "";
    
    // keep track of which components have finished
    SJT3Components = [];
    SJT3Components.push(text_15);
    SJT3Components.push(slider_3);
    SJT3Components.push(related2);
    SJT3Components.push(unrelated2);
    SJT3Components.push(key_resp_14);
    SJT3Components.push(text_21);
    SJT3Components.push(currVal3);
    SJT3Components.push(text_33);
    
    for (const thisComponent of SJT3Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var cVal3;
function SJT3RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'SJT3'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = SJT3Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_15* updates
    if (t >= 0.0 && text_15.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_15.tStart = t;  // (not accounting for frame time here)
      text_15.frameNStart = frameN;  // exact frame index
      
      text_15.setAutoDraw(true);
    }

    
    // *slider_3* updates
    if (t >= 0.0 && slider_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      slider_3.tStart = t;  // (not accounting for frame time here)
      slider_3.frameNStart = frameN;  // exact frame index
      
      slider_3.setAutoDraw(true);
    }

    
    // *related2* updates
    if (t >= 0.0 && related2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      related2.tStart = t;  // (not accounting for frame time here)
      related2.frameNStart = frameN;  // exact frame index
      
      related2.setAutoDraw(true);
    }

    
    // *unrelated2* updates
    if (t >= 0.0 && unrelated2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      unrelated2.tStart = t;  // (not accounting for frame time here)
      unrelated2.frameNStart = frameN;  // exact frame index
      
      unrelated2.setAutoDraw(true);
    }

    
    // *key_resp_14* updates
    if (t >= 0 && key_resp_14.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_14.tStart = t;  // (not accounting for frame time here)
      key_resp_14.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_14.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_14.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_14.clearEvents(); });
    }

    if (key_resp_14.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_14.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_14_allKeys = _key_resp_14_allKeys.concat(theseKeys);
      if (_key_resp_14_allKeys.length > 0) {
        key_resp_14.keys = _key_resp_14_allKeys[_key_resp_14_allKeys.length - 1].name;  // just the last key pressed
        key_resp_14.rt = _key_resp_14_allKeys[_key_resp_14_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_21* updates
    if (t >= 0.0 && text_21.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_21.tStart = t;  // (not accounting for frame time here)
      text_21.frameNStart = frameN;  // exact frame index
      
      text_21.setAutoDraw(true);
    }

    cVal3 = slider_3.markerPos;
    currVal3.text = (Math.round((cVal3 * 100.0)) / 100.0);
    
    
    // *currVal3* updates
    if (t >= 0.0 && currVal3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      currVal3.tStart = t;  // (not accounting for frame time here)
      currVal3.frameNStart = frameN;  // exact frame index
      
      currVal3.setAutoDraw(true);
    }

    
    // *text_33* updates
    if (t >= 0.0 && text_33.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_33.tStart = t;  // (not accounting for frame time here)
      text_33.frameNStart = frameN;  // exact frame index
      
      text_33.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of SJT3Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function SJT3RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'SJT3'-------
    for (const thisComponent of SJT3Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('slider_3.response', slider_3.getRating());
    psychoJS.experiment.addData('slider_3.rt', slider_3.getRT());
    slide3rating = slider_3.getRating();
    slide3rt = slider_3.getRT();
    trials_10.addData("slider3val", slide3rating);
    trials_10.addData("slider3RT", slide3rt);
    
    // the Routine "SJT3" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_20_allKeys;
var stop3Components;
function stop3RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'stop3'-------
    t = 0;
    stop3Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_20.keys = undefined;
    key_resp_20.rt = undefined;
    _key_resp_20_allKeys = [];
    // keep track of which components have finished
    stop3Components = [];
    stop3Components.push(text_16);
    stop3Components.push(key_resp_20);
    
    for (const thisComponent of stop3Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function stop3RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'stop3'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = stop3Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_16* updates
    if (t >= 0.0 && text_16.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_16.tStart = t;  // (not accounting for frame time here)
      text_16.frameNStart = frameN;  // exact frame index
      
      text_16.setAutoDraw(true);
    }

    
    // *key_resp_20* updates
    if (t >= 0.0 && key_resp_20.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_20.tStart = t;  // (not accounting for frame time here)
      key_resp_20.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_20.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_20.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_20.clearEvents(); });
    }

    if (key_resp_20.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_20.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_20_allKeys = _key_resp_20_allKeys.concat(theseKeys);
      if (_key_resp_20_allKeys.length > 0) {
        key_resp_20.keys = _key_resp_20_allKeys[_key_resp_20_allKeys.length - 1].name;  // just the last key pressed
        key_resp_20.rt = _key_resp_20_allKeys[_key_resp_20_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of stop3Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function stop3RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'stop3'-------
    for (const thisComponent of stop3Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "stop3" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_15_allKeys;
var slide4rating;
var slide4rt;
var SJT4Components;
function SJT4RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'SJT4'-------
    t = 0;
    SJT4Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    text_17.setText(combined3);
    slider_4.reset()
    key_resp_15.keys = undefined;
    key_resp_15.rt = undefined;
    _key_resp_15_allKeys = [];
    slider_4.size[1] = (slider_4.size[1] / 2);
    slider_4._applyStyle();
    markerSize = util.to_px(slider_4.size, "height", psychoJS.window)[1];
    slider_4.markerPos = 0.5;
    SJTcounter4 = (SJTcounter4 + 1);
    text_32.text = ((SJTcounter4.toString() + " of") + " 73");
    slide4rating = "";
    slide4rt = "";
    
    // keep track of which components have finished
    SJT4Components = [];
    SJT4Components.push(text_17);
    SJT4Components.push(slider_4);
    SJT4Components.push(related3);
    SJT4Components.push(unrelated3);
    SJT4Components.push(key_resp_15);
    SJT4Components.push(text_22);
    SJT4Components.push(currVal4);
    SJT4Components.push(text_32);
    
    for (const thisComponent of SJT4Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var cVal4;
function SJT4RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'SJT4'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = SJT4Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_17* updates
    if (t >= 0.0 && text_17.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_17.tStart = t;  // (not accounting for frame time here)
      text_17.frameNStart = frameN;  // exact frame index
      
      text_17.setAutoDraw(true);
    }

    
    // *slider_4* updates
    if (t >= 0.0 && slider_4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      slider_4.tStart = t;  // (not accounting for frame time here)
      slider_4.frameNStart = frameN;  // exact frame index
      
      slider_4.setAutoDraw(true);
    }

    
    // *related3* updates
    if (t >= 0.0 && related3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      related3.tStart = t;  // (not accounting for frame time here)
      related3.frameNStart = frameN;  // exact frame index
      
      related3.setAutoDraw(true);
    }

    
    // *unrelated3* updates
    if (t >= 0.0 && unrelated3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      unrelated3.tStart = t;  // (not accounting for frame time here)
      unrelated3.frameNStart = frameN;  // exact frame index
      
      unrelated3.setAutoDraw(true);
    }

    
    // *key_resp_15* updates
    if (t >= 0 && key_resp_15.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_15.tStart = t;  // (not accounting for frame time here)
      key_resp_15.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_15.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_15.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_15.clearEvents(); });
    }

    if (key_resp_15.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_15.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_15_allKeys = _key_resp_15_allKeys.concat(theseKeys);
      if (_key_resp_15_allKeys.length > 0) {
        key_resp_15.keys = _key_resp_15_allKeys[_key_resp_15_allKeys.length - 1].name;  // just the last key pressed
        key_resp_15.rt = _key_resp_15_allKeys[_key_resp_15_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_22* updates
    if (t >= 0.0 && text_22.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_22.tStart = t;  // (not accounting for frame time here)
      text_22.frameNStart = frameN;  // exact frame index
      
      text_22.setAutoDraw(true);
    }

    cVal4 = slider_4.markerPos;
    currVal4.text = (Math.round((cVal4 * 100.0)) / 100.0);
    
    
    // *currVal4* updates
    if (t >= 0.0 && currVal4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      currVal4.tStart = t;  // (not accounting for frame time here)
      currVal4.frameNStart = frameN;  // exact frame index
      
      currVal4.setAutoDraw(true);
    }

    
    // *text_32* updates
    if (t >= 0.0 && text_32.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_32.tStart = t;  // (not accounting for frame time here)
      text_32.frameNStart = frameN;  // exact frame index
      
      text_32.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of SJT4Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function SJT4RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'SJT4'-------
    for (const thisComponent of SJT4Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('slider_4.response', slider_4.getRating());
    psychoJS.experiment.addData('slider_4.rt', slider_4.getRT());
    slide4rating = slider_4.getRating();
    slide4rt = slider_4.getRT();
    trials_11.addData("slider4val", slide4rating);
    trials_11.addData("slider4RT", slide4rt);
    
    // the Routine "SJT4" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_3_allKeys;
var breakNewComponents;
function breakNewRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'breakNew'-------
    t = 0;
    breakNewClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_3.keys = undefined;
    key_resp_3.rt = undefined;
    _key_resp_3_allKeys = [];
    // keep track of which components have finished
    breakNewComponents = [];
    breakNewComponents.push(text_18);
    breakNewComponents.push(key_resp_3);
    
    for (const thisComponent of breakNewComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function breakNewRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'breakNew'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = breakNewClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_18* updates
    if (t >= 0.0 && text_18.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_18.tStart = t;  // (not accounting for frame time here)
      text_18.frameNStart = frameN;  // exact frame index
      
      text_18.setAutoDraw(true);
    }

    
    // *key_resp_3* updates
    if (t >= 0.0 && key_resp_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_3.tStart = t;  // (not accounting for frame time here)
      key_resp_3.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_3.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_3.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_3.clearEvents(); });
    }

    if (key_resp_3.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_3.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_3_allKeys = _key_resp_3_allKeys.concat(theseKeys);
      if (_key_resp_3_allKeys.length > 0) {
        key_resp_3.keys = _key_resp_3_allKeys[_key_resp_3_allKeys.length - 1].name;  // just the last key pressed
        key_resp_3.rt = _key_resp_3_allKeys[_key_resp_3_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of breakNewComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function breakNewRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'breakNew'-------
    for (const thisComponent of breakNewComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "breakNew" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_4_allKeys;
var VfluInstruxComponents;
function VfluInstruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'VfluInstrux'-------
    t = 0;
    VfluInstruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_4.keys = undefined;
    key_resp_4.rt = undefined;
    _key_resp_4_allKeys = [];
    // keep track of which components have finished
    VfluInstruxComponents = [];
    VfluInstruxComponents.push(Instrux2);
    VfluInstruxComponents.push(key_resp_4);
    
    for (const thisComponent of VfluInstruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function VfluInstruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'VfluInstrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = VfluInstruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *Instrux2* updates
    if (t >= 0.0 && Instrux2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Instrux2.tStart = t;  // (not accounting for frame time here)
      Instrux2.frameNStart = frameN;  // exact frame index
      
      Instrux2.setAutoDraw(true);
    }

    
    // *key_resp_4* updates
    if (t >= 2 && key_resp_4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_4.tStart = t;  // (not accounting for frame time here)
      key_resp_4.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_4.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_4.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_4.clearEvents(); });
    }

    if (key_resp_4.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_4.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_4_allKeys = _key_resp_4_allKeys.concat(theseKeys);
      if (_key_resp_4_allKeys.length > 0) {
        key_resp_4.keys = _key_resp_4_allKeys[_key_resp_4_allKeys.length - 1].name;  // just the last key pressed
        key_resp_4.rt = _key_resp_4_allKeys[_key_resp_4_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of VfluInstruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function VfluInstruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'VfluInstrux'-------
    for (const thisComponent of VfluInstruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "VfluInstrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var modify;
var wholeText;
var currentText;
var CountdownClock;
var trialCounter;
var vfComponents;
function vfRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'vf'-------
    t = 0;
    vfClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    category.setText(VFcond);
    modify = false;
    text.text = "";
    psychoJS.eventManager.clearEvents("keyboard");
    wholeText = "";
    currentText = "";
    if ((! countdownStarted)) {
        CountdownClock = new util.CountdownTimer(121);
        countdownStarted = true;
    }
    trialCounter = 2;
    timeText_1.setAutoDraw(true);
    
    // keep track of which components have finished
    vfComponents = [];
    vfComponents.push(category);
    vfComponents.push(text);
    vfComponents.push(timeText_1);
    vfComponents.push(text_3);
    
    for (const thisComponent of vfComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var _pj;
var keys;
var timeRemaining;
function vfRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'vf'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = vfClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *category* updates
    if (t >= 0.0 && category.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      category.tStart = t;  // (not accounting for frame time here)
      category.frameNStart = frameN;  // exact frame index
      
      category.setAutoDraw(true);
    }

    
    // *text* updates
    if (t >= 0.0 && text.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text.tStart = t;  // (not accounting for frame time here)
      text.frameNStart = frameN;  // exact frame index
      
      text.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("space", keys)) {
            text.text = (text.text + " ");
        } else {
            if (_pj.in_es6("backspace", keys)) {
                text.text = text.text.slice(0, (- 1));
            } else {
                if ((_pj.in_es6("lshift", keys) || _pj.in_es6("rshift", keys))) {
                    modify = true;
                } else {
                    if (_pj.in_es6("slash", keys)) {
                        text.text = (text.text + "/");
                    } else {
                        if (_pj.in_es6("comma", keys)) {
                            text.text = (text.text + ",");
                        } else {
                            if (_pj.in_es6("apostrophe", keys)) {
                                text.text = (text.text + "'");
                            } else {
                                if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                                    trials_3.addData("typedWord", text.text);
                                    continueRoutine = false;
                                    psychoJS.eventManager.clearEvents("keyboard");
                                } else {
                                    if (modify) {
                                        modify = false;
                                    } else {
                                        text.text = (text.text + keys[0]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    timeRemaining = CountdownClock.getTime();
    if ((timeRemaining <= 1)) {
        trials.finished = true;
        countdownStarted = false;
        trialCounter = (trialCounter - 1);
    } else {
        minutes = Number.parseInt((timeRemaining / 60.0));
        seconds = Number.parseInt((timeRemaining - (minutes * 60.0)));
        if ((seconds < 10)) {
            seconds = ("0" + seconds.toString());
        }
        timeText = ((minutes.toString() + ":") + seconds.toString());
    }
    timeText_1.text = timeText;
    timeText_1.setAutoDraw(true);
    if ((trialCounter === 0)) {
        continueRoutine = false;
        trials_3.finished = true;
    }
    
    
    // *timeText_1* updates
    if (t >= 0.0 && timeText_1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      timeText_1.tStart = t;  // (not accounting for frame time here)
      timeText_1.frameNStart = frameN;  // exact frame index
      
      timeText_1.setAutoDraw(true);
    }

    
    // *text_3* updates
    if (t >= 0.0 && text_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_3.tStart = t;  // (not accounting for frame time here)
      text_3.frameNStart = frameN;  // exact frame index
      
      text_3.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of vfComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function vfRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'vf'-------
    for (const thisComponent of vfComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    timeText_1.setAutoDraw(false);
    
    // the Routine "vf" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_21_allKeys;
var vfBreakComponents;
function vfBreakRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'vfBreak'-------
    t = 0;
    vfBreakClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_21.keys = undefined;
    key_resp_21.rt = undefined;
    _key_resp_21_allKeys = [];
    // keep track of which components have finished
    vfBreakComponents = [];
    vfBreakComponents.push(text_27);
    vfBreakComponents.push(key_resp_21);
    
    for (const thisComponent of vfBreakComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function vfBreakRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'vfBreak'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = vfBreakClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_27* updates
    if (t >= 0.0 && text_27.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_27.tStart = t;  // (not accounting for frame time here)
      text_27.frameNStart = frameN;  // exact frame index
      
      text_27.setAutoDraw(true);
    }

    
    // *key_resp_21* updates
    if (t >= 0.0 && key_resp_21.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_21.tStart = t;  // (not accounting for frame time here)
      key_resp_21.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_21.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_21.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_21.clearEvents(); });
    }

    if (key_resp_21.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_21.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_21_allKeys = _key_resp_21_allKeys.concat(theseKeys);
      if (_key_resp_21_allKeys.length > 0) {
        key_resp_21.keys = _key_resp_21_allKeys[_key_resp_21_allKeys.length - 1].name;  // just the last key pressed
        key_resp_21.rt = _key_resp_21_allKeys[_key_resp_21_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of vfBreakComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function vfBreakRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'vfBreak'-------
    for (const thisComponent of vfBreakComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "vfBreak" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_6_allKeys;
var vocabExtendIntruxComponents;
function vocabExtendIntruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'vocabExtendIntrux'-------
    t = 0;
    vocabExtendIntruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_6.keys = undefined;
    key_resp_6.rt = undefined;
    _key_resp_6_allKeys = [];
    // keep track of which components have finished
    vocabExtendIntruxComponents = [];
    vocabExtendIntruxComponents.push(vocabIntrux);
    vocabExtendIntruxComponents.push(key_resp_6);
    
    for (const thisComponent of vocabExtendIntruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function vocabExtendIntruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'vocabExtendIntrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = vocabExtendIntruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *vocabIntrux* updates
    if (t >= 0.0 && vocabIntrux.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      vocabIntrux.tStart = t;  // (not accounting for frame time here)
      vocabIntrux.frameNStart = frameN;  // exact frame index
      
      vocabIntrux.setAutoDraw(true);
    }

    
    // *key_resp_6* updates
    if (t >= 3 && key_resp_6.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_6.tStart = t;  // (not accounting for frame time here)
      key_resp_6.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_6.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_6.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_6.clearEvents(); });
    }

    if (key_resp_6.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_6.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_6_allKeys = _key_resp_6_allKeys.concat(theseKeys);
      if (_key_resp_6_allKeys.length > 0) {
        key_resp_6.keys = _key_resp_6_allKeys[_key_resp_6_allKeys.length - 1].name;  // just the last key pressed
        key_resp_6.rt = _key_resp_6_allKeys[_key_resp_6_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of vocabExtendIntruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function vocabExtendIntruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'vocabExtendIntrux'-------
    for (const thisComponent of vocabExtendIntruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "vocabExtendIntrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_16_allKeys;
var Countdown2Clock;
var vocabAdvancedComponents;
function vocabAdvancedRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'vocabAdvanced'-------
    t = 0;
    vocabAdvancedClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    sliderVocab.reset()
    textStimVocab.setText(VocabCue);
    key_resp_16.keys = undefined;
    key_resp_16.rt = undefined;
    _key_resp_16_allKeys = [];
    label1.setText(VR1);
    label2.setText(VR2);
    label3.setText(VR3);
    label4.setText(VR4);
    label5.setText(VR5);
    if ((! countdown2Started)) {
        Countdown2Clock = new util.CountdownTimer(480);
        countdown2Started = true;
    }
    timeText_3.setAutoDraw(true);
    
    // keep track of which components have finished
    vocabAdvancedComponents = [];
    vocabAdvancedComponents.push(vocabInstrux);
    vocabAdvancedComponents.push(sliderVocab);
    vocabAdvancedComponents.push(textStimVocab);
    vocabAdvancedComponents.push(key_resp_16);
    vocabAdvancedComponents.push(text_23);
    vocabAdvancedComponents.push(label1);
    vocabAdvancedComponents.push(label2);
    vocabAdvancedComponents.push(label3);
    vocabAdvancedComponents.push(label4);
    vocabAdvancedComponents.push(label5);
    vocabAdvancedComponents.push(timeText_3);
    
    for (const thisComponent of vocabAdvancedComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var time2Remaining;
function vocabAdvancedRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'vocabAdvanced'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = vocabAdvancedClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *vocabInstrux* updates
    if (t >= 0 && vocabInstrux.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      vocabInstrux.tStart = t;  // (not accounting for frame time here)
      vocabInstrux.frameNStart = frameN;  // exact frame index
      
      vocabInstrux.setAutoDraw(true);
    }

    
    // *sliderVocab* updates
    if (t >= 0 && sliderVocab.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      sliderVocab.tStart = t;  // (not accounting for frame time here)
      sliderVocab.frameNStart = frameN;  // exact frame index
      
      sliderVocab.setAutoDraw(true);
    }

    
    // *textStimVocab* updates
    if (t >= 0 && textStimVocab.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      textStimVocab.tStart = t;  // (not accounting for frame time here)
      textStimVocab.frameNStart = frameN;  // exact frame index
      
      textStimVocab.setAutoDraw(true);
    }

    
    // *key_resp_16* updates
    if (t >= 0 && key_resp_16.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_16.tStart = t;  // (not accounting for frame time here)
      key_resp_16.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_16.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_16.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_16.clearEvents(); });
    }

    if (key_resp_16.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_16.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_16_allKeys = _key_resp_16_allKeys.concat(theseKeys);
      if (_key_resp_16_allKeys.length > 0) {
        key_resp_16.keys = _key_resp_16_allKeys[_key_resp_16_allKeys.length - 1].name;  // just the last key pressed
        key_resp_16.rt = _key_resp_16_allKeys[_key_resp_16_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_23* updates
    if (t >= 0.0 && text_23.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_23.tStart = t;  // (not accounting for frame time here)
      text_23.frameNStart = frameN;  // exact frame index
      
      text_23.setAutoDraw(true);
    }

    
    // *label1* updates
    if (t >= 0.0 && label1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      label1.tStart = t;  // (not accounting for frame time here)
      label1.frameNStart = frameN;  // exact frame index
      
      label1.setAutoDraw(true);
    }

    
    // *label2* updates
    if (t >= 0.0 && label2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      label2.tStart = t;  // (not accounting for frame time here)
      label2.frameNStart = frameN;  // exact frame index
      
      label2.setAutoDraw(true);
    }

    
    // *label3* updates
    if (t >= 0.0 && label3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      label3.tStart = t;  // (not accounting for frame time here)
      label3.frameNStart = frameN;  // exact frame index
      
      label3.setAutoDraw(true);
    }

    
    // *label4* updates
    if (t >= 0.0 && label4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      label4.tStart = t;  // (not accounting for frame time here)
      label4.frameNStart = frameN;  // exact frame index
      
      label4.setAutoDraw(true);
    }

    
    // *label5* updates
    if (t >= 0.0 && label5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      label5.tStart = t;  // (not accounting for frame time here)
      label5.frameNStart = frameN;  // exact frame index
      
      label5.setAutoDraw(true);
    }

    time2Remaining = Countdown2Clock.getTime();
    if ((time2Remaining <= 0)) {
        trials.finished = true;
        continueRoutine = false;
        countdown2Started = false;
    } else {
        minutes2 = Number.parseInt((time2Remaining / 60.0));
        seconds2 = Number.parseInt((time2Remaining - (minutes2 * 60.0)));
        if ((seconds2 < 10)) {
            seconds2 = ("0" + seconds2.toString());
        }
        timeText2 = ((minutes2.toString() + ":") + seconds2.toString());
    }
    timeText_3.text = timeText2;
    timeText_3.setAutoDraw(true);
    
    
    // *timeText_3* updates
    if (t >= 0.0 && timeText_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      timeText_3.tStart = t;  // (not accounting for frame time here)
      timeText_3.frameNStart = frameN;  // exact frame index
      
      timeText_3.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of vocabAdvancedComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function vocabAdvancedRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'vocabAdvanced'-------
    for (const thisComponent of vocabAdvancedComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('sliderVocab.response', sliderVocab.getRating());
    psychoJS.experiment.addData('sliderVocab.rt', sliderVocab.getRT());
    // the Routine "vocabAdvanced" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_24_allKeys;
var Countdown3Clock;
var vocabExtendComponents;
function vocabExtendRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'vocabExtend'-------
    t = 0;
    vocabExtendClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    slider_extend.reset()
    vocabCue.setText(vCue2);
    key_resp_24.keys = undefined;
    key_resp_24.rt = undefined;
    _key_resp_24_allKeys = [];
    r1.setText(R1);
    r2.setText(R2);
    r3.setText(R3);
    if ((! countdown3Started)) {
        Countdown3Clock = new util.CountdownTimer(240);
        countdown3Started = true;
    }
    timeText_4.setAutoDraw(true);
    
    r_04.setText(R4);
    // keep track of which components have finished
    vocabExtendComponents = [];
    vocabExtendComponents.push(vInstrux);
    vocabExtendComponents.push(slider_extend);
    vocabExtendComponents.push(vocabCue);
    vocabExtendComponents.push(key_resp_24);
    vocabExtendComponents.push(text_41);
    vocabExtendComponents.push(r1);
    vocabExtendComponents.push(r2);
    vocabExtendComponents.push(r3);
    vocabExtendComponents.push(timeText_4);
    vocabExtendComponents.push(r_04);
    
    for (const thisComponent of vocabExtendComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function vocabExtendRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'vocabExtend'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = vocabExtendClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *vInstrux* updates
    if (t >= 0.0 && vInstrux.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      vInstrux.tStart = t;  // (not accounting for frame time here)
      vInstrux.frameNStart = frameN;  // exact frame index
      
      vInstrux.setAutoDraw(true);
    }

    
    // *slider_extend* updates
    if (t >= 0.0 && slider_extend.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      slider_extend.tStart = t;  // (not accounting for frame time here)
      slider_extend.frameNStart = frameN;  // exact frame index
      
      slider_extend.setAutoDraw(true);
    }

    
    // *vocabCue* updates
    if (t >= 0.0 && vocabCue.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      vocabCue.tStart = t;  // (not accounting for frame time here)
      vocabCue.frameNStart = frameN;  // exact frame index
      
      vocabCue.setAutoDraw(true);
    }

    
    // *key_resp_24* updates
    if (t >= 0.0 && key_resp_24.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_24.tStart = t;  // (not accounting for frame time here)
      key_resp_24.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_24.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_24.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_24.clearEvents(); });
    }

    if (key_resp_24.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_24.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_24_allKeys = _key_resp_24_allKeys.concat(theseKeys);
      if (_key_resp_24_allKeys.length > 0) {
        key_resp_24.keys = _key_resp_24_allKeys[_key_resp_24_allKeys.length - 1].name;  // just the last key pressed
        key_resp_24.rt = _key_resp_24_allKeys[_key_resp_24_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_41* updates
    if (t >= 0.0 && text_41.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_41.tStart = t;  // (not accounting for frame time here)
      text_41.frameNStart = frameN;  // exact frame index
      
      text_41.setAutoDraw(true);
    }

    
    // *r1* updates
    if (t >= 0.0 && r1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      r1.tStart = t;  // (not accounting for frame time here)
      r1.frameNStart = frameN;  // exact frame index
      
      r1.setAutoDraw(true);
    }

    
    // *r2* updates
    if (t >= 0.0 && r2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      r2.tStart = t;  // (not accounting for frame time here)
      r2.frameNStart = frameN;  // exact frame index
      
      r2.setAutoDraw(true);
    }

    
    // *r3* updates
    if (t >= 0.0 && r3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      r3.tStart = t;  // (not accounting for frame time here)
      r3.frameNStart = frameN;  // exact frame index
      
      r3.setAutoDraw(true);
    }

    time2Remaining = Countdown2Clock.getTime();
    if ((time2Remaining <= 0)) {
        trials.finished = true;
        continueRoutine = false;
        countdown2Started = false;
    } else {
        minutes2 = Number.parseInt((time2Remaining / 60.0));
        seconds2 = Number.parseInt((time2Remaining - (minutes2 * 60.0)));
        if ((seconds2 < 10)) {
            seconds2 = ("0" + seconds2.toString());
        }
        timeText2 = ((minutes2.toString() + ":") + seconds2.toString());
    }
    timeText_4.text = timeText2;
    timeText_4.setAutoDraw(true);
    
    
    // *timeText_4* updates
    if (t >= 0.0 && timeText_4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      timeText_4.tStart = t;  // (not accounting for frame time here)
      timeText_4.frameNStart = frameN;  // exact frame index
      
      timeText_4.setAutoDraw(true);
    }

    
    // *r_04* updates
    if (t >= 0.0 && r_04.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      r_04.tStart = t;  // (not accounting for frame time here)
      r_04.frameNStart = frameN;  // exact frame index
      
      r_04.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of vocabExtendComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function vocabExtendRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'vocabExtend'-------
    for (const thisComponent of vocabExtendComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('slider_extend.response', slider_extend.getRating());
    psychoJS.experiment.addData('slider_extend.rt', slider_extend.getRT());
    // the Routine "vocabExtend" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_25_allKeys;
var break99Components;
function break99RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'break99'-------
    t = 0;
    break99Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_25.keys = undefined;
    key_resp_25.rt = undefined;
    _key_resp_25_allKeys = [];
    // keep track of which components have finished
    break99Components = [];
    break99Components.push(text_42);
    break99Components.push(key_resp_25);
    
    for (const thisComponent of break99Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function break99RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'break99'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = break99Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_42* updates
    if (t >= 0.0 && text_42.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_42.tStart = t;  // (not accounting for frame time here)
      text_42.frameNStart = frameN;  // exact frame index
      
      text_42.setAutoDraw(true);
    }

    
    // *key_resp_25* updates
    if (t >= 0.0 && key_resp_25.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_25.tStart = t;  // (not accounting for frame time here)
      key_resp_25.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_25.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_25.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_25.clearEvents(); });
    }

    if (key_resp_25.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_25.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_25_allKeys = _key_resp_25_allKeys.concat(theseKeys);
      if (_key_resp_25_allKeys.length > 0) {
        key_resp_25.keys = _key_resp_25_allKeys[_key_resp_25_allKeys.length - 1].name;  // just the last key pressed
        key_resp_25.rt = _key_resp_25_allKeys[_key_resp_25_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of break99Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function break99RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'break99'-------
    for (const thisComponent of break99Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "break99" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_8_allKeys;
var FFinstruxComponents;
function FFinstruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'FFinstrux'-------
    t = 0;
    FFinstruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_8.keys = undefined;
    key_resp_8.rt = undefined;
    _key_resp_8_allKeys = [];
    // keep track of which components have finished
    FFinstruxComponents = [];
    FFinstruxComponents.push(text_5);
    FFinstruxComponents.push(key_resp_8);
    
    for (const thisComponent of FFinstruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function FFinstruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'FFinstrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = FFinstruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_5* updates
    if (t >= 0.0 && text_5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_5.tStart = t;  // (not accounting for frame time here)
      text_5.frameNStart = frameN;  // exact frame index
      
      text_5.setAutoDraw(true);
    }

    
    // *key_resp_8* updates
    if (t >= 3 && key_resp_8.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_8.tStart = t;  // (not accounting for frame time here)
      key_resp_8.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_8.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_8.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_8.clearEvents(); });
    }

    if (key_resp_8.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_8.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_8_allKeys = _key_resp_8_allKeys.concat(theseKeys);
      if (_key_resp_8_allKeys.length > 0) {
        key_resp_8.keys = _key_resp_8_allKeys[_key_resp_8_allKeys.length - 1].name;  // just the last key pressed
        key_resp_8.rt = _key_resp_8_allKeys[_key_resp_8_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of FFinstruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function FFinstruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'FFinstrux'-------
    for (const thisComponent of FFinstruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "FFinstrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var lineCounter;
var FFoneComponents;
function FFoneRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'FFone'-------
    t = 0;
    FFoneClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    ffIntrux.setText('Beginning with the following word, write the next word that comes to mind from the previous word.  Please use only single words and proper nouns.');
    lineCounter = 0;
    modify = false;
    text_6.text = "";
    wholeText = "";
    currentText = "";
    
    // keep track of which components have finished
    FFoneComponents = [];
    FFoneComponents.push(ffIntrux);
    FFoneComponents.push(ffprompt);
    FFoneComponents.push(text_6);
    FFoneComponents.push(text_8);
    FFoneComponents.push(last_resp);
    FFoneComponents.push(text_26);
    FFoneComponents.push(polygon);
    
    for (const thisComponent of FFoneComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function FFoneRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'FFone'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = FFoneClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *ffIntrux* updates
    if (t >= 0.0 && ffIntrux.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      ffIntrux.tStart = t;  // (not accounting for frame time here)
      ffIntrux.frameNStart = frameN;  // exact frame index
      
      ffIntrux.setAutoDraw(true);
    }

    
    // *ffprompt* updates
    if (t >= 0 && ffprompt.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      ffprompt.tStart = t;  // (not accounting for frame time here)
      ffprompt.frameNStart = frameN;  // exact frame index
      
      ffprompt.setAutoDraw(true);
    }

    
    // *text_6* updates
    if (t >= 0.0 && text_6.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_6.tStart = t;  // (not accounting for frame time here)
      text_6.frameNStart = frameN;  // exact frame index
      
      text_6.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("space", keys)) {
            text_6.text = (text_6.text + " ");
        } else {
            if (_pj.in_es6("backspace", keys)) {
                text_6.text = text_6.text.slice(0, (- 1));
            } else {
                if ((_pj.in_es6("lshift", keys) || _pj.in_es6("rshift", keys))) {
                    modify = true;
                } else {
                    if (_pj.in_es6("slash", keys)) {
                        text_6.text = (text_6.text + "/");
                    } else {
                        if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                            psychoJS.experiment.addData("ff1", text_6.text);
                            last_resp.text = text_6.text;
                            text_6.text = "";
                            ffprompt.text = "";
                            psychoJS.eventManager.clearEvents("keyboard");
                            continueRoutine = false;
                        } else {
                            if (modify) {
                                modify = false;
                            } else {
                                text_6.text = (text_6.text + keys[0]);
                            }
                        }
                    }
                }
            }
        }
    }
    
    
    // *text_8* updates
    if (t >= 0.0 && text_8.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_8.tStart = t;  // (not accounting for frame time here)
      text_8.frameNStart = frameN;  // exact frame index
      
      text_8.setAutoDraw(true);
    }

    
    // *last_resp* updates
    if (t >= 0.0 && last_resp.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      last_resp.tStart = t;  // (not accounting for frame time here)
      last_resp.frameNStart = frameN;  // exact frame index
      
      last_resp.setAutoDraw(true);
    }

    
    // *text_26* updates
    if (t >= 0.0 && text_26.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_26.tStart = t;  // (not accounting for frame time here)
      text_26.frameNStart = frameN;  // exact frame index
      
      text_26.setAutoDraw(true);
    }

    
    // *polygon* updates
    if (t >= 0.0 && polygon.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      polygon.tStart = t;  // (not accounting for frame time here)
      polygon.frameNStart = frameN;  // exact frame index
      
      polygon.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of FFoneComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function FFoneRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'FFone'-------
    for (const thisComponent of FFoneComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "FFone" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var newWordComponents;
function newWordRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'newWord'-------
    t = 0;
    newWordClock.reset(); // clock
    frameN = -1;
    routineTimer.add(5.000000);
    // update component parameters for each repeat
    // keep track of which components have finished
    newWordComponents = [];
    newWordComponents.push(nBreak);
    
    for (const thisComponent of newWordComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var frameRemains;
function newWordRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'newWord'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = newWordClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *nBreak* updates
    if (t >= 0.0 && nBreak.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      nBreak.tStart = t;  // (not accounting for frame time here)
      nBreak.frameNStart = frameN;  // exact frame index
      
      nBreak.setAutoDraw(true);
    }

    frameRemains = 0.0 + 5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (nBreak.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      nBreak.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of newWordComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function newWordRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'newWord'-------
    for (const thisComponent of newWordComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var FF2Components;
function FF2RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'FF2'-------
    t = 0;
    FF2Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    modify = false;
    text_02.text = "";
    
    // keep track of which components have finished
    FF2Components = [];
    FF2Components.push(text_34);
    FF2Components.push(cue2);
    FF2Components.push(text_02);
    FF2Components.push(lastResp2);
    FF2Components.push(text_35);
    FF2Components.push(text_36);
    FF2Components.push(polygon_2);
    
    for (const thisComponent of FF2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function FF2RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'FF2'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = FF2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_34* updates
    if (t >= 0.0 && text_34.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_34.tStart = t;  // (not accounting for frame time here)
      text_34.frameNStart = frameN;  // exact frame index
      
      text_34.setAutoDraw(true);
    }

    
    // *cue2* updates
    if (t >= 0.0 && cue2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      cue2.tStart = t;  // (not accounting for frame time here)
      cue2.frameNStart = frameN;  // exact frame index
      
      cue2.setAutoDraw(true);
    }

    
    // *text_02* updates
    if (t >= 0.0 && text_02.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_02.tStart = t;  // (not accounting for frame time here)
      text_02.frameNStart = frameN;  // exact frame index
      
      text_02.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("space", keys)) {
            text_02.text = (text_02.text + " ");
        } else {
            if (_pj.in_es6("backspace", keys)) {
                text_02.text = text_02.text.slice(0, (- 1));
            } else {
                if ((_pj.in_es6("lshift", keys) || _pj.in_es6("rshift", keys))) {
                    modify = true;
                } else {
                    if (_pj.in_es6("slash", keys)) {
                        text_02.text = (text_02.text + "/");
                    } else {
                        if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                            psychoJS.experiment.addData("ff2", text_02.text);
                            lastResp2.text = text_02.text;
                            text_02.text = "";
                            cue2.text = "";
                            psychoJS.eventManager.clearEvents("keyboard");
                            continueRoutine = false;
                        } else {
                            if (modify) {
                                modify = false;
                            } else {
                                text_02.text = (text_02.text + keys[0]);
                            }
                        }
                    }
                }
            }
        }
    }
    
    
    // *lastResp2* updates
    if (t >= 0.0 && lastResp2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      lastResp2.tStart = t;  // (not accounting for frame time here)
      lastResp2.frameNStart = frameN;  // exact frame index
      
      lastResp2.setAutoDraw(true);
    }

    
    // *text_35* updates
    if (t >= 0.0 && text_35.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_35.tStart = t;  // (not accounting for frame time here)
      text_35.frameNStart = frameN;  // exact frame index
      
      text_35.setAutoDraw(true);
    }

    
    // *text_36* updates
    if (t >= 0.0 && text_36.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_36.tStart = t;  // (not accounting for frame time here)
      text_36.frameNStart = frameN;  // exact frame index
      
      text_36.setAutoDraw(true);
    }

    
    // *polygon_2* updates
    if (t >= 0.0 && polygon_2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      polygon_2.tStart = t;  // (not accounting for frame time here)
      polygon_2.frameNStart = frameN;  // exact frame index
      
      polygon_2.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of FF2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function FF2RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'FF2'-------
    for (const thisComponent of FF2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "FF2" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var newWord2Components;
function newWord2RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'newWord2'-------
    t = 0;
    newWord2Clock.reset(); // clock
    frameN = -1;
    routineTimer.add(5.000000);
    // update component parameters for each repeat
    // keep track of which components have finished
    newWord2Components = [];
    newWord2Components.push(text_37);
    
    for (const thisComponent of newWord2Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function newWord2RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'newWord2'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = newWord2Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_37* updates
    if (t >= 0.0 && text_37.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_37.tStart = t;  // (not accounting for frame time here)
      text_37.frameNStart = frameN;  // exact frame index
      
      text_37.setAutoDraw(true);
    }

    frameRemains = 0.0 + 5 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text_37.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text_37.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of newWord2Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function newWord2RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'newWord2'-------
    for (const thisComponent of newWord2Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var FFthreeComponents;
function FFthreeRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'FFthree'-------
    t = 0;
    FFthreeClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    modify = false;
    text_03.text = "";
    
    // keep track of which components have finished
    FFthreeComponents = [];
    FFthreeComponents.push(text_38);
    FFthreeComponents.push(cue3);
    FFthreeComponents.push(text_03);
    FFthreeComponents.push(lastResp3);
    FFthreeComponents.push(text_39);
    FFthreeComponents.push(text_40);
    FFthreeComponents.push(polygon_3);
    
    for (const thisComponent of FFthreeComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function FFthreeRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'FFthree'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = FFthreeClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_38* updates
    if (t >= 0.0 && text_38.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_38.tStart = t;  // (not accounting for frame time here)
      text_38.frameNStart = frameN;  // exact frame index
      
      text_38.setAutoDraw(true);
    }

    
    // *cue3* updates
    if (t >= 0.0 && cue3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      cue3.tStart = t;  // (not accounting for frame time here)
      cue3.frameNStart = frameN;  // exact frame index
      
      cue3.setAutoDraw(true);
    }

    
    // *text_03* updates
    if (t >= 0.0 && text_03.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_03.tStart = t;  // (not accounting for frame time here)
      text_03.frameNStart = frameN;  // exact frame index
      
      text_03.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("space", keys)) {
            text_03.text = (text_03.text + " ");
        } else {
            if (_pj.in_es6("backspace", keys)) {
                text_03.text = text_03.text.slice(0, (- 1));
            } else {
                if ((_pj.in_es6("lshift", keys) || _pj.in_es6("rshift", keys))) {
                    modify = true;
                } else {
                    if (_pj.in_es6("slash", keys)) {
                        text_03.text = (text_03.text + "/");
                    } else {
                        if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                            psychoJS.experiment.addData("ff3", text_03.text);
                            lastResp3.text = text_03.text;
                            text_03.text = "";
                            cue3.text = "";
                            psychoJS.eventManager.clearEvents("keyboard");
                            continueRoutine = false;
                        } else {
                            if (modify) {
                                modify = false;
                            } else {
                                text_03.text = (text_03.text + keys[0]);
                            }
                        }
                    }
                }
            }
        }
    }
    
    
    // *lastResp3* updates
    if (t >= 0.0 && lastResp3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      lastResp3.tStart = t;  // (not accounting for frame time here)
      lastResp3.frameNStart = frameN;  // exact frame index
      
      lastResp3.setAutoDraw(true);
    }

    
    // *text_39* updates
    if (t >= 0.0 && text_39.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_39.tStart = t;  // (not accounting for frame time here)
      text_39.frameNStart = frameN;  // exact frame index
      
      text_39.setAutoDraw(true);
    }

    
    // *text_40* updates
    if (t >= 0.0 && text_40.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_40.tStart = t;  // (not accounting for frame time here)
      text_40.frameNStart = frameN;  // exact frame index
      
      text_40.setAutoDraw(true);
    }

    
    // *polygon_3* updates
    if (t >= 0.0 && polygon_3.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      polygon_3.tStart = t;  // (not accounting for frame time here)
      polygon_3.frameNStart = frameN;  // exact frame index
      
      polygon_3.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of FFthreeComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function FFthreeRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'FFthree'-------
    for (const thisComponent of FFthreeComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "FFthree" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_9_allKeys;
var break4Components;
function break4RoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'break4'-------
    t = 0;
    break4Clock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_9.keys = undefined;
    key_resp_9.rt = undefined;
    _key_resp_9_allKeys = [];
    // keep track of which components have finished
    break4Components = [];
    break4Components.push(text_7);
    break4Components.push(key_resp_9);
    
    for (const thisComponent of break4Components)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function break4RoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'break4'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = break4Clock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_7* updates
    if (t >= 0.0 && text_7.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_7.tStart = t;  // (not accounting for frame time here)
      text_7.frameNStart = frameN;  // exact frame index
      
      text_7.setAutoDraw(true);
    }

    
    // *key_resp_9* updates
    if (t >= 0 && key_resp_9.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_9.tStart = t;  // (not accounting for frame time here)
      key_resp_9.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_9.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_9.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_9.clearEvents(); });
    }

    if (key_resp_9.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_9.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_9_allKeys = _key_resp_9_allKeys.concat(theseKeys);
      if (_key_resp_9_allKeys.length > 0) {
        key_resp_9.keys = _key_resp_9_allKeys[_key_resp_9_allKeys.length - 1].name;  // just the last key pressed
        key_resp_9.rt = _key_resp_9_allKeys[_key_resp_9_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of break4Components)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function break4RoutineEnd(trials) {
  return function () {
    //------Ending Routine 'break4'-------
    for (const thisComponent of break4Components) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "break4" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_26_allKeys;
var autInstruxComponents;
function autInstruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'autInstrux'-------
    t = 0;
    autInstruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_26.keys = undefined;
    key_resp_26.rt = undefined;
    _key_resp_26_allKeys = [];
    // keep track of which components have finished
    autInstruxComponents = [];
    autInstruxComponents.push(text_43);
    autInstruxComponents.push(key_resp_26);
    
    for (const thisComponent of autInstruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function autInstruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'autInstrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = autInstruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_43* updates
    if (t >= 0.0 && text_43.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_43.tStart = t;  // (not accounting for frame time here)
      text_43.frameNStart = frameN;  // exact frame index
      
      text_43.setAutoDraw(true);
    }

    
    // *key_resp_26* updates
    if (t >= 0.0 && key_resp_26.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_26.tStart = t;  // (not accounting for frame time here)
      key_resp_26.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_26.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_26.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_26.clearEvents(); });
    }

    if (key_resp_26.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_26.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_26_allKeys = _key_resp_26_allKeys.concat(theseKeys);
      if (_key_resp_26_allKeys.length > 0) {
        key_resp_26.keys = _key_resp_26_allKeys[_key_resp_26_allKeys.length - 1].name;  // just the last key pressed
        key_resp_26.rt = _key_resp_26_allKeys[_key_resp_26_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of autInstruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function autInstruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'autInstrux'-------
    for (const thisComponent of autInstruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "autInstrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var CountdownClock8;
var countdown8Started;
var boxComponents;
function boxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'box'-------
    t = 0;
    boxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    modify = false;
    box_resp.text = "";
    psychoJS.eventManager.clearEvents("keyboard");
    wholeText = "";
    currentText = "";
    if ((! countdown8Started)) {
        CountdownClock8 = new util.CountdownTimer(120);
        countdown8Started = true;
    }
    box_time.setAutoDraw(true);
    
    // keep track of which components have finished
    boxComponents = [];
    boxComponents.push(text_44);
    boxComponents.push(text_45);
    boxComponents.push(box_resp);
    boxComponents.push(polygon_4);
    boxComponents.push(box_time);
    
    for (const thisComponent of boxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var timeRemaining8;
function boxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'box'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = boxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_44* updates
    if (t >= 0.0 && text_44.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_44.tStart = t;  // (not accounting for frame time here)
      text_44.frameNStart = frameN;  // exact frame index
      
      text_44.setAutoDraw(true);
    }

    
    // *text_45* updates
    if (t >= 0.0 && text_45.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_45.tStart = t;  // (not accounting for frame time here)
      text_45.frameNStart = frameN;  // exact frame index
      
      text_45.setAutoDraw(true);
    }

    
    // *box_resp* updates
    if (t >= 0.0 && box_resp.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      box_resp.tStart = t;  // (not accounting for frame time here)
      box_resp.frameNStart = frameN;  // exact frame index
      
      box_resp.setAutoDraw(true);
    }

    
    // *polygon_4* updates
    if (t >= 0.0 && polygon_4.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      polygon_4.tStart = t;  // (not accounting for frame time here)
      polygon_4.frameNStart = frameN;  // exact frame index
      
      polygon_4.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("space", keys)) {
            box_resp.text = (box_resp.text + " ");
        } else {
            if (_pj.in_es6("backspace", keys)) {
                box_resp.text = box_resp.text.slice(0, (- 1));
            } else {
                if ((_pj.in_es6("lshift", keys) || _pj.in_es6("rshift", keys))) {
                    modify = true;
                } else {
                    if (_pj.in_es6("slash", keys)) {
                        box_resp.text = (box_resp.text + "/");
                    } else {
                        if (_pj.in_es6("comma", keys)) {
                            box_resp.text = (box_resp.text + ",");
                        } else {
                            if (_pj.in_es6("apostrophe", keys)) {
                                box_resp.text = (box_resp.text + "'");
                            } else {
                                if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                                    boxTrials.addData("AUTbox", box_resp.text);
                                    continueRoutine = false;
                                    psychoJS.eventManager.clearEvents("keyboard");
                                } else {
                                    if (modify) {
                                        modify = false;
                                    } else {
                                        box_resp.text = (box_resp.text + keys[0]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    timeRemaining8 = CountdownClock8.getTime();
    if ((timeRemaining8 <= 1)) {
        trials.finished = true;
        continueRoutine = false;
        countdown8Started = false;
    } else {
        minutes8 = Number.parseInt((timeRemaining8 / 60.0));
        seconds8 = Number.parseInt((timeRemaining8 - (minutes8 * 60.0)));
        if ((seconds8 < 10)) {
            seconds8 = ("0" + seconds8.toString());
        }
        timeText8 = ((minutes8.toString() + ":") + seconds8.toString());
    }
    box_time.text = timeText8;
    box_time.setAutoDraw(true);
    
    
    // *box_time* updates
    if (t >= 0.0 && box_time.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      box_time.tStart = t;  // (not accounting for frame time here)
      box_time.frameNStart = frameN;  // exact frame index
      
      box_time.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of boxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function boxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'box'-------
    for (const thisComponent of boxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "box" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var nextAUTComponents;
function nextAUTRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'nextAUT'-------
    t = 0;
    nextAUTClock.reset(); // clock
    frameN = -1;
    routineTimer.add(4.000000);
    // update component parameters for each repeat
    // keep track of which components have finished
    nextAUTComponents = [];
    nextAUTComponents.push(text_46);
    
    for (const thisComponent of nextAUTComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function nextAUTRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'nextAUT'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = nextAUTClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_46* updates
    if (t >= 0.0 && text_46.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_46.tStart = t;  // (not accounting for frame time here)
      text_46.frameNStart = frameN;  // exact frame index
      
      text_46.setAutoDraw(true);
    }

    frameRemains = 0.0 + 4 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text_46.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text_46.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of nextAUTComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function nextAUTRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'nextAUT'-------
    for (const thisComponent of nextAUTComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var CountdownClock9;
var countdown9Started;
var ropeComponents;
function ropeRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'rope'-------
    t = 0;
    ropeClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    modify = false;
    rope_resp.text = "";
    psychoJS.eventManager.clearEvents("keyboard");
    wholeText = "";
    currentText = "";
    if ((! countdown9Started)) {
        CountdownClock9 = new util.CountdownTimer(120);
        countdown9Started = true;
    }
    rope_time.setAutoDraw(true);
    
    // keep track of which components have finished
    ropeComponents = [];
    ropeComponents.push(text_47);
    ropeComponents.push(text_48);
    ropeComponents.push(rope_resp);
    ropeComponents.push(polygon_5);
    ropeComponents.push(rope_time);
    
    for (const thisComponent of ropeComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var timeRemaining9;
function ropeRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'rope'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = ropeClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_47* updates
    if (t >= 0.0 && text_47.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_47.tStart = t;  // (not accounting for frame time here)
      text_47.frameNStart = frameN;  // exact frame index
      
      text_47.setAutoDraw(true);
    }

    
    // *text_48* updates
    if (t >= 0.0 && text_48.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_48.tStart = t;  // (not accounting for frame time here)
      text_48.frameNStart = frameN;  // exact frame index
      
      text_48.setAutoDraw(true);
    }

    
    // *rope_resp* updates
    if (t >= 0.0 && rope_resp.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      rope_resp.tStart = t;  // (not accounting for frame time here)
      rope_resp.frameNStart = frameN;  // exact frame index
      
      rope_resp.setAutoDraw(true);
    }

    
    // *polygon_5* updates
    if (t >= 0.0 && polygon_5.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      polygon_5.tStart = t;  // (not accounting for frame time here)
      polygon_5.frameNStart = frameN;  // exact frame index
      
      polygon_5.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("space", keys)) {
            rope_resp.text = (rope_resp.text + " ");
        } else {
            if (_pj.in_es6("backspace", keys)) {
                rope_resp.text = rope_resp.text.slice(0, (- 1));
            } else {
                if ((_pj.in_es6("lshift", keys) || _pj.in_es6("rshift", keys))) {
                    modify = true;
                } else {
                    if (_pj.in_es6("slash", keys)) {
                        rope_resp.text = (rope_resp.text + "/");
                    } else {
                        if (_pj.in_es6("comma", keys)) {
                            rope_resp.text = (rope_resp.text + ",");
                        } else {
                            if (_pj.in_es6("apostrophe", keys)) {
                                rope_resp.text = (rope_resp.text + "'");
                            } else {
                                if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                                    ropeTrials.addData("AUTrope", rope_resp.text);
                                    continueRoutine = false;
                                    psychoJS.eventManager.clearEvents("keyboard");
                                } else {
                                    if (modify) {
                                        modify = false;
                                    } else {
                                        rope_resp.text = (rope_resp.text + keys[0]);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    timeRemaining9 = CountdownClock9.getTime();
    if ((timeRemaining9 <= 1)) {
        trials.finished = true;
        continueRoutine = false;
        countdown9Started = false;
    } else {
        minutes9 = Number.parseInt((timeRemaining9 / 60.0));
        seconds9 = Number.parseInt((timeRemaining9 - (minutes9 * 60.0)));
        if ((seconds9 < 10)) {
            seconds9 = ("0" + seconds9.toString());
        }
        timeText9 = ((minutes9.toString() + ":") + seconds9.toString());
    }
    rope_time.text = timeText9;
    rope_time.setAutoDraw(true);
    
    
    // *rope_time* updates
    if (t >= 0.0 && rope_time.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      rope_time.tStart = t;  // (not accounting for frame time here)
      rope_time.frameNStart = frameN;  // exact frame index
      
      rope_time.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of ropeComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function ropeRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'rope'-------
    for (const thisComponent of ropeComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "rope" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_10_allKeys;
var catellInstruxComponents;
function catellInstruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'catellInstrux'-------
    t = 0;
    catellInstruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_10.keys = undefined;
    key_resp_10.rt = undefined;
    _key_resp_10_allKeys = [];
    // keep track of which components have finished
    catellInstruxComponents = [];
    catellInstruxComponents.push(Catellinstrux);
    catellInstruxComponents.push(text_9);
    catellInstruxComponents.push(CattelExample);
    catellInstruxComponents.push(key_resp_10);
    catellInstruxComponents.push(dir2);
    
    for (const thisComponent of catellInstruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function catellInstruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'catellInstrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = catellInstruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *Catellinstrux* updates
    if (t >= 0.0 && Catellinstrux.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Catellinstrux.tStart = t;  // (not accounting for frame time here)
      Catellinstrux.frameNStart = frameN;  // exact frame index
      
      Catellinstrux.setAutoDraw(true);
    }

    
    // *text_9* updates
    if (t >= 0.0 && text_9.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_9.tStart = t;  // (not accounting for frame time here)
      text_9.frameNStart = frameN;  // exact frame index
      
      text_9.setAutoDraw(true);
    }

    
    // *CattelExample* updates
    if (t >= 0.0 && CattelExample.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      CattelExample.tStart = t;  // (not accounting for frame time here)
      CattelExample.frameNStart = frameN;  // exact frame index
      
      CattelExample.setAutoDraw(true);
    }

    
    // *key_resp_10* updates
    if (t >= 3 && key_resp_10.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_10.tStart = t;  // (not accounting for frame time here)
      key_resp_10.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_10.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_10.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_10.clearEvents(); });
    }

    if (key_resp_10.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_10.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_10_allKeys = _key_resp_10_allKeys.concat(theseKeys);
      if (_key_resp_10_allKeys.length > 0) {
        key_resp_10.keys = _key_resp_10_allKeys[_key_resp_10_allKeys.length - 1].name;  // just the last key pressed
        key_resp_10.rt = _key_resp_10_allKeys[_key_resp_10_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *dir2* updates
    if (t >= 0.0 && dir2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      dir2.tStart = t;  // (not accounting for frame time here)
      dir2.frameNStart = frameN;  // exact frame index
      
      dir2.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of catellInstruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function catellInstruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'catellInstrux'-------
    for (const thisComponent of catellInstruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "catellInstrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var GetReadyComponents;
function GetReadyRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'GetReady'-------
    t = 0;
    GetReadyClock.reset(); // clock
    frameN = -1;
    routineTimer.add(3.000000);
    // update component parameters for each repeat
    // keep track of which components have finished
    GetReadyComponents = [];
    GetReadyComponents.push(text_10);
    
    for (const thisComponent of GetReadyComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function GetReadyRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'GetReady'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = GetReadyClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_10* updates
    if (t >= 0.0 && text_10.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_10.tStart = t;  // (not accounting for frame time here)
      text_10.frameNStart = frameN;  // exact frame index
      
      text_10.setAutoDraw(true);
    }

    frameRemains = 0.0 + 3 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text_10.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text_10.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of GetReadyComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function GetReadyRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'GetReady'-------
    for (const thisComponent of GetReadyComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


var timeText4;
var minutes4;
var seconds4;
var _key_resp_17_allKeys;
var CattelComponents;
function CattelRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'Cattel'-------
    t = 0;
    CattelClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    sliderCattel.reset()
    modify = false;
    timeText4 = "";
    minutes4 = "";
    seconds4 = "";
    if ((! countdown4Started)) {
        cattellClock = new util.CountdownTimer(180);
        countdown4Started = true;
    }
    trialCounter = 2;
    
    key_resp_17.keys = undefined;
    key_resp_17.rt = undefined;
    _key_resp_17_allKeys = [];
    Img1.setImage(CattelImage);
    // keep track of which components have finished
    CattelComponents = [];
    CattelComponents.push(sliderCattel);
    CattelComponents.push(timer2);
    CattelComponents.push(key_resp_17);
    CattelComponents.push(text_24);
    CattelComponents.push(Img1);
    
    for (const thisComponent of CattelComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


var time4Remaining;
function CattelRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'Cattel'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = CattelClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *sliderCattel* updates
    if (t >= 0.2 && sliderCattel.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      sliderCattel.tStart = t;  // (not accounting for frame time here)
      sliderCattel.frameNStart = frameN;  // exact frame index
      
      sliderCattel.setAutoDraw(true);
    }

    time4Remaining = cattellClock.getTime();
    if ((time4Remaining <= 0)) {
        continueRoutine = false;
        trials.finished = true;
    } else {
        minutes4 = Number.parseInt((time4Remaining / 60.0));
        seconds4 = Number.parseInt((time4Remaining - (minutes4 * 60.0)));
        if ((seconds4 < 10)) {
            seconds4 = ("0" + seconds3.toString());
        }
        timeText4 = ((minutes4.toString() + ":") + seconds4.toString());
    }
    timer2.text = timeText4;
    timer2.setAutoDraw(true);
    
    
    // *timer2* updates
    if (t >= 0.0 && timer2.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      timer2.tStart = t;  // (not accounting for frame time here)
      timer2.frameNStart = frameN;  // exact frame index
      
      timer2.setAutoDraw(true);
    }

    
    if (timer2.status === PsychoJS.Status.STARTED){ // only update if being drawn
      timer2.setText(timeText);
    }
    
    // *key_resp_17* updates
    if (t >= 0.5 && key_resp_17.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_17.tStart = t;  // (not accounting for frame time here)
      key_resp_17.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_17.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_17.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_17.clearEvents(); });
    }

    if (key_resp_17.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_17.getKeys({keyList: ['space'], waitRelease: false});
      _key_resp_17_allKeys = _key_resp_17_allKeys.concat(theseKeys);
      if (_key_resp_17_allKeys.length > 0) {
        key_resp_17.keys = _key_resp_17_allKeys[_key_resp_17_allKeys.length - 1].name;  // just the last key pressed
        key_resp_17.rt = _key_resp_17_allKeys[_key_resp_17_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    
    // *text_24* updates
    if (t >= 0.0 && text_24.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_24.tStart = t;  // (not accounting for frame time here)
      text_24.frameNStart = frameN;  // exact frame index
      
      text_24.setAutoDraw(true);
    }

    
    // *Img1* updates
    if (t >= 0.2 && Img1.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      Img1.tStart = t;  // (not accounting for frame time here)
      Img1.frameNStart = frameN;  // exact frame index
      
      Img1.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of CattelComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function CattelRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'Cattel'-------
    for (const thisComponent of CattelComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('sliderCattel.response', sliderCattel.getRating());
    psychoJS.experiment.addData('sliderCattel.rt', sliderCattel.getRT());
    // the Routine "Cattel" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_11_allKeys;
var demoInstruxComponents;
function demoInstruxRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'demoInstrux'-------
    t = 0;
    demoInstruxClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    key_resp_11.keys = undefined;
    key_resp_11.rt = undefined;
    _key_resp_11_allKeys = [];
    // keep track of which components have finished
    demoInstruxComponents = [];
    demoInstruxComponents.push(text_11);
    demoInstruxComponents.push(key_resp_11);
    
    for (const thisComponent of demoInstruxComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function demoInstruxRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'demoInstrux'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = demoInstruxClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_11* updates
    if (t >= 0.0 && text_11.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_11.tStart = t;  // (not accounting for frame time here)
      text_11.frameNStart = frameN;  // exact frame index
      
      text_11.setAutoDraw(true);
    }

    
    // *key_resp_11* updates
    if (t >= 1 && key_resp_11.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_11.tStart = t;  // (not accounting for frame time here)
      key_resp_11.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_11.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_11.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_11.clearEvents(); });
    }

    if (key_resp_11.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_11.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_11_allKeys = _key_resp_11_allKeys.concat(theseKeys);
      if (_key_resp_11_allKeys.length > 0) {
        key_resp_11.keys = _key_resp_11_allKeys[_key_resp_11_allKeys.length - 1].name;  // just the last key pressed
        key_resp_11.rt = _key_resp_11_allKeys[_key_resp_11_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of demoInstruxComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function demoInstruxRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'demoInstrux'-------
    for (const thisComponent of demoInstruxComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "demoInstrux" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_22_allKeys;
var GenderComponents;
function GenderRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'Gender'-------
    t = 0;
    GenderClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    text_12.setText('What is your gender?');
    genderSlide.reset()
    key_resp_22.keys = undefined;
    key_resp_22.rt = undefined;
    _key_resp_22_allKeys = [];
    // keep track of which components have finished
    GenderComponents = [];
    GenderComponents.push(text_12);
    GenderComponents.push(genderSlide);
    GenderComponents.push(text_25);
    GenderComponents.push(key_resp_22);
    
    for (const thisComponent of GenderComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function GenderRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'Gender'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = GenderClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_12* updates
    if (t >= 0.0 && text_12.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_12.tStart = t;  // (not accounting for frame time here)
      text_12.frameNStart = frameN;  // exact frame index
      
      text_12.setAutoDraw(true);
    }

    
    // *genderSlide* updates
    if (t >= 0.0 && genderSlide.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      genderSlide.tStart = t;  // (not accounting for frame time here)
      genderSlide.frameNStart = frameN;  // exact frame index
      
      genderSlide.setAutoDraw(true);
    }

    
    // *text_25* updates
    if (t >= 0.0 && text_25.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_25.tStart = t;  // (not accounting for frame time here)
      text_25.frameNStart = frameN;  // exact frame index
      
      text_25.setAutoDraw(true);
    }

    
    // *key_resp_22* updates
    if (t >= 0.0 && key_resp_22.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_22.tStart = t;  // (not accounting for frame time here)
      key_resp_22.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_22.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_22.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_22.clearEvents(); });
    }

    if (key_resp_22.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_22.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_22_allKeys = _key_resp_22_allKeys.concat(theseKeys);
      if (_key_resp_22_allKeys.length > 0) {
        key_resp_22.keys = _key_resp_22_allKeys[_key_resp_22_allKeys.length - 1].name;  // just the last key pressed
        key_resp_22.rt = _key_resp_22_allKeys[_key_resp_22_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of GenderComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function GenderRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'Gender'-------
    for (const thisComponent of GenderComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('genderSlide.response', genderSlide.getRating());
    psychoJS.experiment.addData('genderSlide.rt', genderSlide.getRT());
    // the Routine "Gender" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var AgeComponents;
function AgeRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'Age'-------
    t = 0;
    AgeClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    ageResp.text = "";
    continueRoutine = true;
    psychoJS.eventManager.clearEvents("keyboard");
    
    // keep track of which components have finished
    AgeComponents = [];
    AgeComponents.push(ageQ);
    AgeComponents.push(ageResp);
    AgeComponents.push(text_29);
    
    for (const thisComponent of AgeComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function AgeRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'Age'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = AgeClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *ageQ* updates
    if (t >= 0.0 && ageQ.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      ageQ.tStart = t;  // (not accounting for frame time here)
      ageQ.frameNStart = frameN;  // exact frame index
      
      ageQ.setAutoDraw(true);
    }

    
    // *ageResp* updates
    if (t >= 0.0 && ageResp.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      ageResp.tStart = t;  // (not accounting for frame time here)
      ageResp.frameNStart = frameN;  // exact frame index
      
      ageResp.setAutoDraw(true);
    }

    var _pj;
    function _pj_snippets(container) {
        function in_es6(left, right) {
            if (((right instanceof Array) || ((typeof right) === "string"))) {
                return (right.indexOf(left) > (- 1));
            } else {
                if (((right instanceof Map) || (right instanceof Set) || (right instanceof WeakMap) || (right instanceof WeakSet))) {
                    return right.has(left);
                } else {
                    return (left in right);
                }
            }
        }
        container["in_es6"] = in_es6;
        return container;
    }
    _pj = {};
    _pj_snippets(_pj);
    keys = psychoJS.eventManager.getKeys();
    if (keys.length) {
        if (_pj.in_es6("1", keys)) {
            ageResp.text = (ageResp.text + "1");
        } else {
            if (_pj.in_es6("2", keys)) {
                ageResp.text = (ageResp.text + "2");
            } else {
                if (_pj.in_es6("3", keys)) {
                    ageResp.text = (ageResp.text + "3");
                } else {
                    if (_pj.in_es6("4", keys)) {
                        ageResp.text = (ageResp.text + "4");
                    } else {
                        if (_pj.in_es6("5", keys)) {
                            ageResp.text = (ageResp.text + "5");
                        } else {
                            if (_pj.in_es6("6", keys)) {
                                ageResp.text = (ageResp.text + "6");
                            } else {
                                if (_pj.in_es6("7", keys)) {
                                    ageResp.text = (ageResp.text + "7");
                                } else {
                                    if (_pj.in_es6("8", keys)) {
                                        ageResp.text = (ageResp.text + "8");
                                    } else {
                                        if (_pj.in_es6("9", keys)) {
                                            ageResp.text = (ageResp.text + "9");
                                        } else {
                                            if (_pj.in_es6("0", keys)) {
                                                ageResp.text = (ageResp.text + "0");
                                            } else {
                                                if ((_pj.in_es6("return", keys) && (keys.length >= 1))) {
                                                    trials_7.addData("age", ageResp.text);
                                                    continueRoutine = false;
                                                } else {
                                                    if (modify) {
                                                        modify = false;
                                                    } else {
                                                        ageResp.text = (ageResp.text + keys[0]);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
    
    
    // *text_29* updates
    if (t >= 0.0 && text_29.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_29.tStart = t;  // (not accounting for frame time here)
      text_29.frameNStart = frameN;  // exact frame index
      
      text_29.setAutoDraw(true);
    }

    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of AgeComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function AgeRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'Age'-------
    for (const thisComponent of AgeComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    // the Routine "Age" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var _key_resp_23_allKeys;
var EFLComponents;
function EFLRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'EFL'-------
    t = 0;
    EFLClock.reset(); // clock
    frameN = -1;
    // update component parameters for each repeat
    engSlide.reset()
    key_resp_23.keys = undefined;
    key_resp_23.rt = undefined;
    _key_resp_23_allKeys = [];
    // keep track of which components have finished
    EFLComponents = [];
    EFLComponents.push(eng);
    EFLComponents.push(engSlide);
    EFLComponents.push(text_28);
    EFLComponents.push(key_resp_23);
    
    for (const thisComponent of EFLComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function EFLRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'EFL'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = EFLClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *eng* updates
    if (t >= 0.0 && eng.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      eng.tStart = t;  // (not accounting for frame time here)
      eng.frameNStart = frameN;  // exact frame index
      
      eng.setAutoDraw(true);
    }

    
    // *engSlide* updates
    if (t >= 0.0 && engSlide.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      engSlide.tStart = t;  // (not accounting for frame time here)
      engSlide.frameNStart = frameN;  // exact frame index
      
      engSlide.setAutoDraw(true);
    }

    
    // *text_28* updates
    if (t >= 0.0 && text_28.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_28.tStart = t;  // (not accounting for frame time here)
      text_28.frameNStart = frameN;  // exact frame index
      
      text_28.setAutoDraw(true);
    }

    
    // *key_resp_23* updates
    if (t >= 0.0 && key_resp_23.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      key_resp_23.tStart = t;  // (not accounting for frame time here)
      key_resp_23.frameNStart = frameN;  // exact frame index
      
      // keyboard checking is just starting
      psychoJS.window.callOnFlip(function() { key_resp_23.clock.reset(); });  // t=0 on next screen flip
      psychoJS.window.callOnFlip(function() { key_resp_23.start(); }); // start on screen flip
      psychoJS.window.callOnFlip(function() { key_resp_23.clearEvents(); });
    }

    if (key_resp_23.status === PsychoJS.Status.STARTED) {
      let theseKeys = key_resp_23.getKeys({keyList: ['return'], waitRelease: false});
      _key_resp_23_allKeys = _key_resp_23_allKeys.concat(theseKeys);
      if (_key_resp_23_allKeys.length > 0) {
        key_resp_23.keys = _key_resp_23_allKeys[_key_resp_23_allKeys.length - 1].name;  // just the last key pressed
        key_resp_23.rt = _key_resp_23_allKeys[_key_resp_23_allKeys.length - 1].rt;
        // a response ends the routine
        continueRoutine = false;
      }
    }
    
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of EFLComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function EFLRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'EFL'-------
    for (const thisComponent of EFLComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    psychoJS.experiment.addData('engSlide.response', engSlide.getRating());
    psychoJS.experiment.addData('engSlide.rt', engSlide.getRT());
    // the Routine "EFL" was not non-slip safe, so reset the non-slip timer
    routineTimer.reset();
    
    return Scheduler.Event.NEXT;
  };
}


var thanksComponents;
function thanksRoutineBegin(trials) {
  return function () {
    //------Prepare to start Routine 'thanks'-------
    t = 0;
    thanksClock.reset(); // clock
    frameN = -1;
    routineTimer.add(4.000000);
    // update component parameters for each repeat
    // keep track of which components have finished
    thanksComponents = [];
    thanksComponents.push(text_13);
    
    for (const thisComponent of thanksComponents)
      if ('status' in thisComponent)
        thisComponent.status = PsychoJS.Status.NOT_STARTED;
    
    return Scheduler.Event.NEXT;
  };
}


function thanksRoutineEachFrame(trials) {
  return function () {
    //------Loop for each frame of Routine 'thanks'-------
    let continueRoutine = true; // until we're told otherwise
    // get current time
    t = thanksClock.getTime();
    frameN = frameN + 1;// number of completed frames (so 0 is the first frame)
    // update/draw components on each frame
    
    // *text_13* updates
    if (t >= 0.0 && text_13.status === PsychoJS.Status.NOT_STARTED) {
      // keep track of start time/frame for later
      text_13.tStart = t;  // (not accounting for frame time here)
      text_13.frameNStart = frameN;  // exact frame index
      
      text_13.setAutoDraw(true);
    }

    frameRemains = 0.0 + 4 - psychoJS.window.monitorFramePeriod * 0.75;  // most of one frame period left
    if (text_13.status === PsychoJS.Status.STARTED && t >= frameRemains) {
      text_13.setAutoDraw(false);
    }
    // check for quit (typically the Esc key)
    if (psychoJS.experiment.experimentEnded || psychoJS.eventManager.getKeys({keyList:['escape']}).length > 0) {
      return quitPsychoJS('The [Escape] key was pressed. Goodbye!', false);
    }
    
    // check if the Routine should terminate
    if (!continueRoutine) {  // a component has requested a forced-end of Routine
      return Scheduler.Event.NEXT;
    }
    
    continueRoutine = false;  // reverts to True if at least one component still running
    for (const thisComponent of thanksComponents)
      if ('status' in thisComponent && thisComponent.status !== PsychoJS.Status.FINISHED) {
        continueRoutine = true;
        break;
      }
    
    // refresh the screen if continuing
    if (continueRoutine && routineTimer.getTime() > 0) {
      return Scheduler.Event.FLIP_REPEAT;
    } else {
      return Scheduler.Event.NEXT;
    }
  };
}


function thanksRoutineEnd(trials) {
  return function () {
    //------Ending Routine 'thanks'-------
    for (const thisComponent of thanksComponents) {
      if (typeof thisComponent.setAutoDraw === 'function') {
        thisComponent.setAutoDraw(false);
      }
    }
    return Scheduler.Event.NEXT;
  };
}


function endLoopIteration(thisScheduler, loop) {
  // ------Prepare for next entry------
  return function () {
    if (typeof loop !== 'undefined') {
      // ------Check if user ended loop early------
      if (loop.finished) {
        // Check for and save orphaned data
        if (psychoJS.experiment.isEntryEmpty()) {
          psychoJS.experiment.nextEntry(loop);
        }
      thisScheduler.stop();
      } else {
        const thisTrial = loop.getCurrentTrial();
        if (typeof thisTrial === 'undefined' || !('isTrials' in thisTrial) || thisTrial.isTrials) {
          psychoJS.experiment.nextEntry(loop);
        }
      }
    return Scheduler.Event.NEXT;
    }
  };
}


function importConditions(trials) {
  return function () {
    psychoJS.importAttributes(trials.getCurrentTrial());
    return Scheduler.Event.NEXT;
    };
}


function quitPsychoJS(message, isCompleted) {
  // Check for and save orphaned data
  if (psychoJS.experiment.isEntryEmpty()) {
    psychoJS.experiment.nextEntry();
  }
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  
  psychoJS.window.close();
  psychoJS.quit({message: message, isCompleted: isCompleted});
  
  return Scheduler.Event.QUIT;
}
